/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import picocli.CommandLine;

public abstract class AbstractUpdatesCommand
extends AbstractCommand
implements Runnable {
    private static final int FEATURE_DISABLED_EXIT_CODE = 4;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin;

    @Override
    public List<OptionCategory> getOptionCategories() {
        return super.getOptionCategories().stream().filter(Predicate.not(arg_0 -> OptionCategory.EXPORT.equals(arg_0))).filter(Predicate.not(arg_0 -> OptionCategory.IMPORT.equals(arg_0))).toList();
    }

    @Override
    public void run() {
        Environment.updateProfile(true);
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V1)) {
            this.printFeatureDisabled();
            this.picocli.exit(4);
            return;
        }
        AbstractUpdatesCommand.loadConfiguration();
        this.printPreviewWarning();
        this.validateConfig();
        int exitCode = this.executeAction();
        this.picocli.exit(exitCode);
    }

    abstract int executeAction();

    static void validateFileIsNotDirectory(File file, String option) {
        if (file.isDirectory()) {
            throw new PropertyException("Incorrect argument %s. Path '%s' is not a valid file.".formatted(option, file.getAbsolutePath()));
        }
    }

    void printOut(String message) {
        Optional<CommandLine> cmd = this.getCommandLine();
        if (cmd.isPresent()) {
            cmd.get().getOut().println(message);
        } else {
            System.out.println(message);
        }
    }

    void printError(String message) {
        Optional<CommandLine> cmd = this.getCommandLine();
        if (cmd.isPresent()) {
            CommandLine.Help.ColorScheme colorScheme = cmd.get().getColorScheme();
            cmd.get().getErr().println(colorScheme.errorText(message));
        } else {
            System.err.println(message);
        }
    }

    private void printPreviewWarning() {
        if (Profile.Feature.ROLLING_UPDATES_V1.getType() == Profile.Feature.Type.PREVIEW) {
            this.printError("Warning! This command is '" + String.valueOf(Profile.Feature.ROLLING_UPDATES_V1.getType()) + "' and is not recommended for use in production. It may change or be removed at a future release.");
        }
    }

    void printFeatureDisabled() {
        this.printError("Unable to use this command. The feature '" + Profile.Feature.ROLLING_UPDATES_V1.getVersionedKey() + "' is not enabled.");
    }

    static Map<String, CompatibilityMetadataProvider> loadAllProviders() {
        HashMap<String, CompatibilityMetadataProvider> providers = new HashMap<String, CompatibilityMetadataProvider>();
        for (CompatibilityMetadataProvider p : ServiceLoader.load(CompatibilityMetadataProvider.class)) {
            providers.merge(p.getId(), p, (existing, current) -> {
                if (existing.priority() == current.priority()) {
                    throw new IllegalArgumentException("Unable to handle two providers with the same id (%s) and priority.".formatted(existing.getId()));
                }
                return existing.priority() < current.priority() ? current : existing;
            });
        }
        return providers;
    }

    private static void loadConfiguration() {
        Config.ConfigProvider configProvider = (Config.ConfigProvider)ServiceLoader.load(ConfigProviderFactory.class).stream().findFirst().map(ServiceLoader.Provider::get).flatMap(ConfigProviderFactory::create).orElseThrow(() -> new RuntimeException("Failed to load Keycloak Configuration"));
        Config.init((Config.ConfigProvider)configProvider);
    }
}

