/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.utils.StringUtil;

public class UserResource {
    private final KeycloakSession session;
    private final UserModel user;

    public UserResource(KeycloakSession session, UserModel user) {
        this.session = session;
        this.user = user;
    }

    @GET
    @Path(value="unmanagedAttributes")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, List<String>> getUnmanagedAttributes() {
        UserProfileProvider provider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.USER_API, this.user);
        Map managedAttributes = profile.getAttributes().getReadable();
        HashMap attributes = new HashMap(this.user.getAttributes());
        UPConfig upConfig = provider.getConfiguration();
        if (upConfig.getUnmanagedAttributePolicy() == null) {
            return Collections.emptyMap();
        }
        Map unmanagedAttributes = profile.getAttributes().getUnmanagedAttributes();
        managedAttributes.entrySet().removeAll(unmanagedAttributes.entrySet());
        attributes.entrySet().removeAll(managedAttributes.entrySet());
        attributes.remove("username");
        attributes.remove("email");
        return attributes.entrySet().stream().filter(entry -> Optional.ofNullable((List)entry.getValue()).orElse(Collections.emptyList()).stream().anyMatch(StringUtil::isNotBlank)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

