/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.admin.ui.rest.model.SessionId;
import org.keycloak.admin.ui.rest.model.SessionRepresentation;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class SessionsResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public SessionsResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        this.session = session;
        this.realm = realm;
        this.auth = auth;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all sessions of the current realm also the once that use offline tokens", description="This endpoint returns a list of sessions and the clients that have been used including offline tokens")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=SessionRepresentation.class, type=SchemaType.ARRAY))})
    public Stream<SessionRepresentation> realmSessions(@QueryParam(value="type") @DefaultValue(value="ALL") SessionId.SessionType type, @QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max) {
        this.auth.realm().requireViewRealm();
        Stream<SessionId> sessionIdStream = Stream.builder().build();
        if (type == SessionId.SessionType.ALL || type == SessionId.SessionType.REGULAR) {
            Map clientSessionStats = this.session.sessions().getActiveClientSessionStats(this.realm, false);
            sessionIdStream = Stream.concat(sessionIdStream, clientSessionStats.keySet().stream().map(i -> new SessionId((String)i, SessionId.SessionType.REGULAR)));
        }
        if (type == SessionId.SessionType.ALL || type == SessionId.SessionType.OFFLINE) {
            sessionIdStream = Stream.concat(sessionIdStream, this.session.sessions().getActiveClientSessionStats(this.realm, true).keySet().stream().map(i -> new SessionId((String)i, SessionId.SessionType.OFFLINE)));
        }
        Stream<Object> result = sessionIdStream.flatMap(sessionId -> {
            ClientModel clientModel = this.realm.getClientById(sessionId.getClientId());
            switch (sessionId.getType()) {
                case REGULAR: {
                    return this.session.sessions().getUserSessionsStream(this.realm, clientModel).map(s -> this.toUserSessionRepresentation((UserSessionModel)s, sessionId.getClientId(), SessionId.SessionType.REGULAR));
                }
                case OFFLINE: {
                    return this.session.sessions().getOfflineUserSessionsStream(this.realm, clientModel, null, null).map(s -> this.toUserSessionRepresentation((UserSessionModel)s, sessionId.getClientId(), SessionId.SessionType.OFFLINE));
                }
            }
            return Stream.builder().build();
        }).distinct();
        if (!search.equals("")) {
            result = result.filter(s -> s.getUsername().contains(search) || s.getIpAddress().contains(search) || s.getClients().values().stream().anyMatch(c -> c.contains(search)));
        }
        return result.skip(first).limit(max);
    }

    private SessionRepresentation toUserSessionRepresentation(UserSessionModel userSession, String clientId, SessionId.SessionType type) {
        SessionRepresentation rep = SessionsResource.toRepresentation(userSession, type);
        userSession.getAuthenticatedClientSessions().entrySet().stream().filter(entry -> Objects.equals(clientId, entry.getKey())).findFirst().ifPresent(result -> rep.setLastAccess(Time.toMillis((long)((AuthenticatedClientSessionModel)result.getValue()).getTimestamp())));
        return rep;
    }

    public static SessionRepresentation toRepresentation(UserSessionModel session, SessionId.SessionType type) {
        SessionRepresentation rep = new SessionRepresentation();
        rep.setId(session.getId());
        rep.setStart(Time.toMillis((long)session.getStarted()));
        rep.setLastAccess(Time.toMillis((long)session.getLastSessionRefresh()));
        rep.setUsername(session.getUser().getUsername());
        rep.setUserId(session.getUser().getId());
        rep.setIpAddress(session.getIpAddress());
        rep.setType(type);
        for (AuthenticatedClientSessionModel clientSession : session.getAuthenticatedClientSessions().values()) {
            ClientModel client = clientSession.getClient();
            rep.getClients().put(client.getId(), client.getClientId());
        }
        return rep;
    }
}

