/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.admin.ui.rest.RoleMappingResource;
import org.keycloak.admin.ui.rest.model.ClientRole;
import org.keycloak.admin.ui.rest.model.RoleMapper;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.common.Profile;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class AvailableRoleMappingResource
extends RoleMappingResource {
    public AvailableRoleMappingResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        super(session, realm, auth);
    }

    @GET
    @Path(value="/clientScopes/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all available client roles for this client scope", description="This endpoint returns all the client roles the user can add to a specific client scope")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listAvailableClientScopeRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        ClientScopeModel scopeModel = this.realm.getClientScopeById(id);
        if (scopeModel == null) {
            if (this.auth.clients().canListClientScopes()) {
                throw new NotFoundException("Could not find client scope");
            }
            throw new ForbiddenException();
        }
        if (this.auth.hasOneAdminRole(new String[]{AdminRoles.MANAGE_CLIENTS})) {
            Stream<String> excludedRoleIds = scopeModel.getScopeMappingsStream().filter(RoleModel::isClientRole).map(RoleModel::getId);
            return this.searchForClientRolesByExcludedIds(this.realm, search, first, max, excludedRoleIds);
        }
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            this.auth.clients().requireView(scopeModel);
            Set<String> roleIds = this.getRoleIdsWithPermissions("map-role-client-scope", "map-roles-client-scope");
            scopeModel.getScopeMappingsStream().forEach(role -> roleIds.remove(role.getId()));
            return this.searchForClientRolesByIds(this.realm, roleIds.stream(), search, first, max);
        }
        return Collections.emptyList();
    }

    @GET
    @Path(value="/clients/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all available client roles for the scope mapping of this client", description="This endpoint returns all the client roles a user can add to the scope mapping of a specific client")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listAvailableClientRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        ClientModel client = this.realm.getClientById(id);
        if (client == null) {
            if (this.auth.clients().canList()) {
                throw new NotFoundException("Could not find client");
            }
            throw new ForbiddenException();
        }
        if (this.auth.hasOneAdminRole(new String[]{AdminRoles.MANAGE_CLIENTS})) {
            Stream<String> excludedRoleIds = Stream.concat(client.getScopeMappingsStream(), client.getRolesStream()).filter(RoleModel::isClientRole).map(RoleModel::getId);
            return this.searchForClientRolesByExcludedIds(this.realm, search, first, max, excludedRoleIds);
        }
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            this.auth.clients().requireView(client);
            Set<String> roleIds = this.getRoleIdsWithPermissions("map-role-client-scope", "map-roles-client-scope");
            Stream.concat(client.getScopeMappingsStream(), client.getRolesStream()).forEach(role -> roleIds.remove(role.getId()));
            return this.searchForClientRolesByIds(this.realm, roleIds.stream(), search, first, max);
        }
        return Collections.emptyList();
    }

    @GET
    @Path(value="/groups/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all available client roles for this group", description="This endpoint returns all available client roles a user can add to a specific group")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listAvailableGroupRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            if (this.auth.groups().canList()) {
                throw new NotFoundException("Could not find group");
            }
            throw new ForbiddenException();
        }
        if (this.auth.hasOneAdminRole(new String[]{AdminRoles.MANAGE_USERS})) {
            Stream<String> excludedRoleIds = group.getRoleMappingsStream().filter(RoleModel::isClientRole).map(RoleModel::getId);
            return this.searchForClientRolesByExcludedIds(this.realm, search, first, max, excludedRoleIds);
        }
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            this.auth.groups().requireView(group);
            Set<String> roleIds = this.getRoleIdsWithPermissions("map-role", "map-roles");
            group.getRoleMappingsStream().forEach(role -> roleIds.remove(role.getId()));
            return this.searchForClientRolesByIds(this.realm, roleIds.stream(), search, first, max);
        }
        return Collections.emptyList();
    }

    @GET
    @Path(value="/users/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all available client roles for this user", description="This endpoint returns all the available client roles a user can add to a specific user")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listAvailableUserRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        UserProvider users = Objects.requireNonNull(this.session).users();
        UserModel userModel = users.getUserById(this.realm, id);
        if (userModel == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        if (this.auth.hasOneAdminRole(new String[]{AdminRoles.MANAGE_USERS})) {
            Stream<String> excludedRoleIds = userModel.getRoleMappingsStream().filter(RoleModel::isClientRole).map(RoleModel::getId);
            return this.searchForClientRolesByExcludedIds(this.realm, search, first, max, excludedRoleIds);
        }
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            this.auth.users().requireView(userModel);
            if (!this.auth.users().canMapRoles(userModel)) {
                return Collections.emptyList();
            }
            Set<String> roleIds = this.getRoleIdsWithPermissions("map-role", "map-roles");
            userModel.getRoleMappingsStream().forEach(role -> roleIds.remove(role.getId()));
            return this.searchForClientRolesByIds(this.realm, roleIds.stream(), search, first, max);
        }
        return Collections.emptyList();
    }

    @GET
    @Path(value="/roles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all available client roles to map as composite role", description="This endpoint returns all available client roles to map as composite role")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listAvailableRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        if (this.auth.hasOneAdminRole(new String[]{AdminRoles.MANAGE_USERS})) {
            return this.searchForClientRolesByExcludedIds(this.realm, search, first, max, Stream.of(id));
        }
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            Set<String> roleIds = this.getRoleIdsWithPermissions("map-role-composite", "map-roles-composite");
            roleIds.remove(id);
            return this.searchForClientRolesByIds(this.realm, roleIds.stream(), search, first, max);
        }
        return Collections.emptyList();
    }

    private Set<String> getRoleIdsWithPermissions(String roleResourceScope, String clientResourceScope) {
        Set<String> roleIds;
        if (AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) && this.canPerformOnAllClients(clientResourceScope)) {
            roleIds = this.session.clients().getClientsStream(this.realm).flatMap(client -> client.getRolesStream()).map(RoleModel::getId).collect(Collectors.toSet());
        } else {
            roleIds = this.auth.roles().getRoleIdsByScope(roleResourceScope);
            Set clientIds = this.auth.clients().getClientIdsByScope(clientResourceScope);
            clientIds.stream().flatMap(cid -> this.realm.getClientById(cid).getRolesStream()).forEach(role -> roleIds.add(role.getId()));
        }
        return roleIds;
    }

    private List<ClientRole> searchForClientRolesByIds(RealmModel realm, Stream<String> includedIDs, String search, int first, int max) {
        Stream result = this.session.roles().searchForClientRolesStream(realm, includedIDs, search, Integer.valueOf(first), Integer.valueOf(max));
        return result.map(role -> RoleMapper.convertToModel(role, realm)).collect(Collectors.toList());
    }

    private List<ClientRole> searchForClientRolesByExcludedIds(RealmModel realm, String search, int first, int max, Stream<String> excludedIds) {
        Stream result = this.session.roles().searchForClientRolesStream(realm, search, excludedIds, Integer.valueOf(first), Integer.valueOf(max));
        return result.map(role -> RoleMapper.convertToModel(role, realm)).collect(Collectors.toList());
    }

    private boolean canPerformOnAllClients(String scope) {
        switch (scope) {
            case "map-roles": {
                return this.auth.clients().canMapRoles(null);
            }
            case "map-roles-composite": {
                return this.auth.clients().canMapCompositeRoles(null);
            }
            case "map-roles-client-scope": {
                return this.auth.clients().canMapClientScopeRoles(null);
            }
        }
        return false;
    }
}

