/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.InitiateLogin;
import org.keycloak.adapters.saml.SamlAuthenticationError;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.Base64;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SamlAuthenticator {
    protected static Logger log = Logger.getLogger(SamlAuthenticator.class);
    protected HttpFacade facade;
    protected AuthChallenge challenge;
    protected SamlDeployment deployment;
    protected SamlSessionStore sessionStore;

    public SamlAuthenticator(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        this.facade = facade;
        this.deployment = deployment;
        this.sessionStore = sessionStore;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public AuthOutcome authenticate() {
        String samlRequest = this.facade.getRequest().getFirstParam("SAMLRequest");
        String samlResponse = this.facade.getRequest().getFirstParam("SAMLResponse");
        String relayState = this.facade.getRequest().getFirstParam("RelayState");
        boolean globalLogout = "true".equals(this.facade.getRequest().getQueryParamValue("GLO"));
        if (samlRequest != null) {
            return this.handleSamlRequest(samlRequest, relayState);
        }
        if (samlResponse != null) {
            return this.handleSamlResponse(samlResponse, relayState);
        }
        if (this.sessionStore.isLoggedIn()) {
            if (globalLogout) {
                return this.globalLogout();
            }
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"AUTHENTICATED: was cached");
            return AuthOutcome.AUTHENTICATED;
        }
        return this.initiateLogin();
    }

    protected AuthOutcome globalLogout() {
        SamlSession account = this.sessionStore.getAccount();
        if (account == null) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(30).issuer(this.deployment.getEntityID()).sessionIndex(account.getSessionIndex()).userPrincipal(account.getPrincipal().getSamlSubject(), account.getPrincipal().getNameIDFormat()).destination(this.deployment.getIDP().getSingleLogoutService().getRequestBindingUrl());
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
        if (this.deployment.getIDP().getSingleLogoutService().signRequest()) {
            binding.signWith(this.deployment.getSigningKeyPair()).signDocument();
        }
        binding.relayState("logout");
        try {
            SamlUtil.sendSaml(true, this.facade, this.deployment.getIDP().getSingleLogoutService().getRequestBindingUrl(), binding, logoutBuilder.buildDocument(), this.deployment.getIDP().getSingleLogoutService().getRequestBinding());
            this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.LOGGING_OUT);
        }
        catch (Exception e) {
            log.error((Object)"Could not send global logout SAML request", (Throwable)e);
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.NOT_ATTEMPTED;
    }

    protected AuthOutcome handleSamlRequest(String samlRequest, String relayState) {
        SAMLDocumentHolder holder = null;
        boolean postBinding = false;
        String requestUri = this.facade.getRequest().getURI();
        if (this.facade.getRequest().getMethod().equalsIgnoreCase("GET")) {
            int index = requestUri.indexOf(63);
            if (index > -1) {
                requestUri = requestUri.substring(0, index);
            }
            holder = SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        } else {
            postBinding = true;
            holder = SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }
        RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
        if (!requestUri.equals(requestAbstractType.getDestination().toString())) {
            log.error((Object)("expected destination '" + requestUri + "' got '" + requestAbstractType.getDestination() + "'"));
            return AuthOutcome.FAILED;
        }
        if (requestAbstractType instanceof LogoutRequestType) {
            if (this.deployment.getIDP().getSingleLogoutService().validateRequestSignature()) {
                try {
                    this.validateSamlSignature(holder, postBinding, "SAMLRequest");
                }
                catch (VerificationException e) {
                    log.error((Object)"Failed to verify saml request signature", (Throwable)e);
                    return AuthOutcome.FAILED;
                }
            }
            LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
            return this.logoutRequest(logout, relayState);
        }
        log.error((Object)"unknown SAML request type");
        return AuthOutcome.FAILED;
    }

    protected AuthOutcome logoutRequest(LogoutRequestType request, String relayState) {
        if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
            this.sessionStore.logoutByPrincipal(request.getNameID().getValue());
        } else {
            this.sessionStore.logoutBySsoId(request.getSessionIndex());
        }
        String issuerURL = this.deployment.getEntityID();
        SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
        builder.logoutRequestID(request.getID());
        builder.destination(this.deployment.getIDP().getSingleLogoutService().getResponseBindingUrl());
        builder.issuer(issuerURL);
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder().relayState(relayState);
        if (this.deployment.getIDP().getSingleLogoutService().signResponse()) {
            binding.signatureAlgorithm(this.deployment.getSignatureAlgorithm()).signWith(this.deployment.getSigningKeyPair()).signDocument();
            if (this.deployment.getSignatureCanonicalizationMethod() != null) {
                binding.canonicalizationMethod(this.deployment.getSignatureCanonicalizationMethod());
            }
        }
        try {
            SamlUtil.sendSaml(false, this.facade, this.deployment.getIDP().getSingleLogoutService().getResponseBindingUrl(), binding, builder.buildDocument(), this.deployment.getIDP().getSingleLogoutService().getResponseBinding());
        }
        catch (Exception e) {
            log.error((Object)"Could not send logout response SAML request", (Throwable)e);
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthOutcome handleSamlResponse(String samlResponse, String relayState) {
        SAMLDocumentHolder holder = null;
        boolean postBinding = false;
        String requestUri = this.facade.getRequest().getURI();
        if (this.facade.getRequest().getMethod().equalsIgnoreCase("GET")) {
            int index = requestUri.indexOf(63);
            if (index > -1) {
                requestUri = requestUri.substring(0, index);
            }
            holder = this.extractRedirectBindingResponse(samlResponse);
        } else {
            postBinding = true;
            holder = this.extractPostBindingResponse(samlResponse);
        }
        final StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
        if (!requestUri.equals(statusResponse.getDestination())) {
            log.error((Object)"Request URI does not match SAML request destination");
            return AuthOutcome.FAILED;
        }
        if (statusResponse instanceof ResponseType) {
            try {
                if (this.deployment.getIDP().getSingleSignOnService().validateResponseSignature()) {
                    try {
                        this.validateSamlSignature(holder, postBinding, "SAMLResponse");
                    }
                    catch (VerificationException e) {
                        log.error((Object)"Failed to verify saml response signature", (Throwable)e);
                        this.challenge = new AuthChallenge(){

                            public boolean challenge(HttpFacade exchange) {
                                SamlAuthenticationError error = new SamlAuthenticationError(SamlAuthenticationError.Reason.INVALID_SIGNATURE);
                                exchange.getRequest().setError((AuthenticationError)error);
                                exchange.getResponse().sendError(403);
                                return true;
                            }

                            public int getResponseCode() {
                                return 403;
                            }
                        };
                        AuthOutcome authOutcome = AuthOutcome.FAILED;
                        this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
                        return authOutcome;
                    }
                }
                AuthOutcome e = this.handleLoginResponse((ResponseType)statusResponse);
                return e;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        if (this.sessionStore.isLoggingOut()) {
            try {
                if (this.deployment.getIDP().getSingleLogoutService().validateResponseSignature()) {
                    try {
                        this.validateSamlSignature(holder, postBinding, "SAMLResponse");
                    }
                    catch (VerificationException e) {
                        log.error((Object)"Failed to verify saml response signature", (Throwable)e);
                        AuthOutcome authOutcome = AuthOutcome.FAILED;
                        this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
                        return authOutcome;
                    }
                }
                AuthOutcome e = this.handleLogoutResponse(holder, statusResponse, relayState);
                return e;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        if (this.sessionStore.isLoggingIn()) {
            try {
                StatusType status = statusResponse.getStatus();
                if (this.checkStatusCodeValue(status.getStatusCode(), JBossSAMLURIConstants.STATUS_RESPONDER.get()) && this.checkStatusCodeValue(status.getStatusCode().getStatusCode(), JBossSAMLURIConstants.STATUS_NO_PASSIVE.get())) {
                    log.debug((Object)("Not authenticated due passive mode Status found in SAML response: " + status.toString()));
                    AuthOutcome authOutcome = AuthOutcome.NOT_AUTHENTICATED;
                    return authOutcome;
                }
                this.challenge = new AuthChallenge(){

                    public boolean challenge(HttpFacade exchange) {
                        SamlAuthenticationError error = new SamlAuthenticationError(SamlAuthenticationError.Reason.ERROR_STATUS, statusResponse);
                        exchange.getRequest().setError((AuthenticationError)error);
                        exchange.getResponse().sendError(403);
                        return true;
                    }

                    public int getResponseCode() {
                        return 403;
                    }
                };
                AuthOutcome authOutcome = AuthOutcome.FAILED;
                return authOutcome;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        return AuthOutcome.NOT_ATTEMPTED;
    }

    private void validateSamlSignature(SAMLDocumentHolder holder, boolean postBinding, String paramKey) throws VerificationException {
        if (postBinding) {
            this.verifyPostBindingSignature(holder.getSamlDocument(), this.deployment.getIDP().getSignatureValidationKey());
        } else {
            this.verifyRedirectBindingSignature(this.deployment.getIDP().getSignatureValidationKey(), paramKey);
        }
    }

    private boolean checkStatusCodeValue(StatusCodeType statusCode, String expectedValue) {
        if (statusCode != null && statusCode.getValue() != null) {
            String v = statusCode.getValue().toString();
            return expectedValue.equals(v);
        }
        return false;
    }

    protected AuthOutcome handleLoginResponse(ResponseType responseType) {
        String index;
        URI nameFormat;
        AssertionType assertion = null;
        try {
            assertion = AssertionUtil.getAssertion((ResponseType)responseType, (PrivateKey)this.deployment.getDecryptionKey());
            if (AssertionUtil.hasExpired((AssertionType)assertion)) {
                return this.initiateLogin();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error extracting SAML assertion: " + e.getMessage()));
            this.challenge = new AuthChallenge(){

                public boolean challenge(HttpFacade exchange) {
                    SamlAuthenticationError error = new SamlAuthenticationError(SamlAuthenticationError.Reason.EXTRACTION_FAILURE);
                    exchange.getRequest().setError((AuthenticationError)error);
                    exchange.getResponse().sendError(403);
                    return true;
                }

                public int getResponseCode() {
                    return 403;
                }
            };
        }
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        NameIDType subjectNameID = (NameIDType)subType.getBaseID();
        String principalName = subjectNameID.getValue();
        HashSet<String> roles = new HashSet<String>();
        MultivaluedHashMap attributes = new MultivaluedHashMap();
        MultivaluedHashMap friendlyAttributes = new MultivaluedHashMap();
        Set statements = assertion.getStatements();
        for (Object statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attributeStatement = (AttributeStatementType)statement;
            List attList = attributeStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType obj : attList) {
                List attributeValues;
                AttributeType attr = obj.getAttribute();
                if (this.isRole(attr)) {
                    attributeValues = attr.getAttributeValue();
                    if (attributeValues == null) continue;
                    for (Object attrValue : attributeValues) {
                        String role = this.getAttributeValue(attrValue);
                        log.debugv("Add role: {0}", (Object)role);
                        roles.add(role);
                    }
                    continue;
                }
                attributeValues = attr.getAttributeValue();
                if (attributeValues == null) continue;
                for (Object attrValue : attributeValues) {
                    String value = this.getAttributeValue(attrValue);
                    if (attr.getName() != null) {
                        attributes.add((Object)attr.getName(), (Object)value);
                    }
                    if (attr.getFriendlyName() == null) continue;
                    friendlyAttributes.add((Object)attr.getFriendlyName(), (Object)value);
                }
            }
        }
        if (this.deployment.getPrincipalNamePolicy() == SamlDeployment.PrincipalNamePolicy.FROM_ATTRIBUTE && this.deployment.getPrincipalAttributeName() != null) {
            String attribute = (String)attributes.getFirst((Object)this.deployment.getPrincipalAttributeName());
            if (attribute != null) {
                principalName = attribute;
            } else {
                attribute = (String)friendlyAttributes.getFirst((Object)this.deployment.getPrincipalAttributeName());
                if (attribute != null) {
                    principalName = attribute;
                }
            }
        }
        AuthnStatementType authn = null;
        for (Object statement : assertion.getStatements()) {
            if (!(statement instanceof AuthnStatementType)) continue;
            authn = (AuthnStatementType)statement;
            break;
        }
        String nameFormatString = (nameFormat = subjectNameID.getFormat()) == null ? JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get() : nameFormat.toString();
        SamlPrincipal principal = new SamlPrincipal(assertion, principalName, principalName, nameFormatString, (MultivaluedHashMap<String, String>)attributes, (MultivaluedHashMap<String, String>)friendlyAttributes);
        String sessionIndex = index = authn == null ? null : authn.getSessionIndex();
        SamlSession account = new SamlSession(principal, roles, sessionIndex);
        this.sessionStore.saveAccount(account);
        this.completeAuthentication(account);
        String redirectUri = this.sessionStore.getRedirectUri();
        if (redirectUri != null) {
            this.facade.getResponse().setHeader("Location", redirectUri);
            this.facade.getResponse().setStatus(302);
            this.facade.getResponse().end();
        } else {
            log.debug((Object)"IDP initiated invocation");
        }
        log.debug((Object)"AUTHENTICATED authn");
        return AuthOutcome.AUTHENTICATED;
    }

    protected abstract void completeAuthentication(SamlSession var1);

    private String getAttributeValue(Object attrValue) {
        String value = null;
        if (attrValue instanceof String) {
            value = (String)attrValue;
        } else if (attrValue instanceof Node) {
            Node roleNode = (Node)attrValue;
            value = roleNode.getFirstChild().getNodeValue();
        } else if (attrValue instanceof NameIDType) {
            NameIDType nameIdType = (NameIDType)attrValue;
            value = nameIdType.getValue();
        } else {
            log.warn((Object)("Unable to extract unknown SAML assertion attribute value type: " + attrValue.getClass().getName()));
        }
        return value;
    }

    protected boolean isRole(AttributeType attribute) {
        return attribute.getName() != null && this.deployment.getRoleAttributeNames().contains(attribute.getName()) || attribute.getFriendlyName() != null && this.deployment.getRoleAttributeNames().contains(attribute.getFriendlyName());
    }

    protected AuthOutcome handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
        boolean loggedIn = this.sessionStore.isLoggedIn();
        if (!loggedIn || !"logout".equals(relayState)) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.sessionStore.logoutAccount();
        return AuthOutcome.LOGGED_OUT;
    }

    protected SAMLDocumentHolder extractRedirectBindingResponse(String response) {
        return SAMLRequestParser.parseRequestRedirectBinding((String)response);
    }

    protected SAMLDocumentHolder extractPostBindingResponse(String response) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
        return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
    }

    protected AuthOutcome initiateLogin() {
        this.challenge = new InitiateLogin(this.deployment, this.sessionStore);
        return AuthOutcome.NOT_ATTEMPTED;
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.warn((Object)"SSL is required to authenticate");
            return true;
        }
        return false;
    }

    public void verifyPostBindingSignature(Document document, PublicKey publicKey) throws VerificationException {
        SAML2Signature saml2Signature = new SAML2Signature();
        try {
            if (!saml2Signature.validate(document, publicKey)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    public void verifyRedirectBindingSignature(PublicKey publicKey, String paramKey) throws VerificationException {
        String request = this.facade.getRequest().getQueryParamValue(paramKey);
        String algorithm = this.facade.getRequest().getQueryParamValue("SigAlg");
        String signature = this.facade.getRequest().getQueryParamValue("Signature");
        String decodedAlgorithm = this.facade.getRequest().getQueryParamValue("SigAlg");
        if (request == null) {
            throw new VerificationException("SAML Request was null");
        }
        if (algorithm == null) {
            throw new VerificationException("SigAlg was null");
        }
        if (signature == null) {
            throw new VerificationException("Signature was null");
        }
        String relayState = this.facade.getRequest().getQueryParamValue("RelayState");
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromPath((String)"/").queryParam(paramKey, new Object[]{request});
        if (relayState != null) {
            builder.queryParam("RelayState", new Object[]{relayState});
        }
        builder.queryParam("SigAlg", new Object[]{algorithm});
        String rawQuery = builder.build(new Object[0]).getRawQuery();
        try {
            byte[] decodedSignature = Base64.decode((String)signature);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getFromXmlMethod((String)decodedAlgorithm);
            Signature validator = signatureAlgorithm.createSignature();
            validator.initVerify(publicKey);
            validator.update(rawQuery.getBytes("UTF-8"));
            if (!validator.verify(decodedSignature)) {
                throw new VerificationException("Invalid query param signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }
}

