/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.AttributeQueryType;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.RequestedAuthnContextType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.BaseWriter;
import org.w3c.dom.Element;

public class SAMLRequestWriter
extends BaseWriter {
    public SAMLRequestWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AuthnRequestType request) throws ProcessingException {
        RequestedAuthnContextType requestedAuthnContext;
        NameIDPolicyType nameIDPolicy;
        ExtensionsType extensions;
        Element sig;
        NameIDType issuer;
        String providerName;
        Integer attrIndex;
        Integer assertionIndex;
        URI protocolBinding;
        Boolean isPassive;
        Boolean forceAuthn;
        URI assertionURL;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.AUTHN_REQUEST.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((assertionURL = request.getAssertionConsumerServiceURL()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_URL.get(), assertionURL.toASCIIString());
        }
        if ((forceAuthn = request.isForceAuthn()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FORCE_AUTHN.get(), forceAuthn.toString());
        }
        if ((isPassive = request.isIsPassive()) != null && isPassive.booleanValue()) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.IS_PASSIVE.get(), isPassive.toString());
        }
        if ((protocolBinding = request.getProtocolBinding()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.PROTOCOL_BINDING.get(), protocolBinding.toString());
        }
        if ((assertionIndex = request.getAssertionConsumerServiceIndex()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_INDEX.get(), assertionIndex.toString());
        }
        if ((attrIndex = request.getAttributeConsumingServiceIndex()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE_INDEX.get(), attrIndex.toString());
        }
        if (StringUtil.isNotNull(providerName = request.getProviderName())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.PROVIDER_NAME.get(), providerName);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((extensions = request.getExtensions()) != null && !extensions.getAny().isEmpty()) {
            this.write(extensions);
        }
        if ((nameIDPolicy = request.getNameIDPolicy()) != null) {
            this.write(nameIDPolicy);
        }
        if ((requestedAuthnContext = request.getRequestedAuthnContext()) != null) {
            this.write(requestedAuthnContext);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(LogoutRequestType logOutRequest) throws ProcessingException {
        NameIDType nameID;
        ExtensionsType extensions;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.LOGOUT_REQUEST.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), logOutRequest.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), logOutRequest.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), logOutRequest.getIssueInstant().toString());
        URI destination = logOutRequest.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = logOutRequest.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        NameIDType issuer = logOutRequest.getIssuer();
        this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        Element signature = logOutRequest.getSignature();
        if (signature != null) {
            StaxUtil.writeDOMElement(this.writer, signature);
        }
        if ((extensions = logOutRequest.getExtensions()) != null && !extensions.getAny().isEmpty()) {
            this.write(extensions);
        }
        if ((nameID = logOutRequest.getNameID()) != null) {
            this.write(nameID, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        }
        List sessionIndexes = logOutRequest.getSessionIndex();
        for (String sessionIndex : sessionIndexes) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.SESSION_INDEX.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeCharacters(this.writer, sessionIndex);
            StaxUtil.writeEndElement(this.writer);
            StaxUtil.flush(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(NameIDPolicyType nameIDPolicy) throws ProcessingException {
        Boolean allowCreate;
        String spNameQualifier;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.NAMEID_POLICY.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        URI format = nameIDPolicy.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FORMAT.get(), format.toASCIIString());
        }
        if (StringUtil.isNotNull(spNameQualifier = nameIDPolicy.getSPNameQualifier())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.SP_NAME_QUALIFIER.get(), spNameQualifier);
        }
        if (!((allowCreate = nameIDPolicy.isAllowCreate()) == null || format != null && JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get().equals(format.toASCIIString()))) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ALLOW_CREATE.get(), allowCreate.toString());
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(RequestedAuthnContextType requestedAuthnContextType) throws ProcessingException {
        List authnContextClassRef;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.REQUESTED_AUTHN_CONTEXT.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        AuthnContextComparisonType comparison = requestedAuthnContextType.getComparison();
        if (comparison != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.COMPARISON.get(), comparison.value());
        }
        if ((authnContextClassRef = requestedAuthnContextType.getAuthnContextClassRef()) != null && !authnContextClassRef.isEmpty()) {
            for (String classRef : authnContextClassRef) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, classRef);
                StaxUtil.writeEndElement(this.writer);
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(ArtifactResolveType request) throws ProcessingException {
        String artifact;
        ExtensionsType extensions;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ARTIFACT_RESOLVE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((extensions = request.getExtensions()) != null && !extensions.getAny().isEmpty()) {
            this.write(extensions);
        }
        if (StringUtil.isNotNull(artifact = request.getArtifact())) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ARTIFACT.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeCharacters(this.writer, artifact);
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AttributeQueryType request) throws ProcessingException {
        SubjectType subject;
        ExtensionsType extensions;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ATTRIBUTE_QUERY.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((extensions = request.getExtensions()) != null && !extensions.getAny().isEmpty()) {
            this.write(extensions);
        }
        if ((subject = request.getSubject()) != null) {
            this.write(subject);
        }
        List attributes = request.getAttribute();
        for (AttributeType attr : attributes) {
            this.write(attr);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

