/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class QNameEnumLookup<E extends Enum<E>> {
    private final Map<QName, E> qNameConstants;

    public QNameEnumLookup(E[] e) {
        HashMap<QName, E> q = new HashMap<QName, E>(e.length);
        for (E c : e) {
            QName qName = ((HasQName)c).getQName();
            Enum old = (Enum)q.put(qName, c);
            if (old != null) {
                throw new IllegalStateException("Same name " + qName + " used for two distinct constants: " + c + ", " + old);
            }
            if (qName.getNamespaceURI() == null || Objects.equals(qName.getNamespaceURI(), "")) continue;
            if (q.containsKey(qName = new QName(qName.getLocalPart()))) {
                q.put(qName, null);
                continue;
            }
            q.put(qName, c);
        }
        this.qNameConstants = Collections.unmodifiableMap(q);
    }

    public E from(QName name) {
        Enum c = (Enum)this.qNameConstants.get(name);
        if (c == null) {
            name = new QName(name.getLocalPart());
            c = (Enum)this.qNameConstants.get(name);
        }
        return (E)c;
    }
}

