/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;

public class UserPropertyAttributeStatementMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    private static final List<ProtocolMapper.ConfigProperty> configProperties = new ArrayList<ProtocolMapper.ConfigProperty>();
    public static final String PROVIDER_ID = "saml-user-property-mapper";

    public List<ProtocolMapper.ConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Property";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Map a built in user property to a SAML attribute type.";
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        UserModel user = userSession.getUser();
        String propertyName = (String)mappingModel.getConfig().get("user.attribute");
        String propertyValue = ProtocolMapperUtils.getUserModelValue((UserModel)user, (String)propertyName);
        AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, propertyValue);
    }

    public static ProtocolMapperModel createAttributeMapper(String name, String userAttribute, String samlAttributeName, String nameFormat, String friendlyName, boolean consentRequired, String consentText) {
        String mapperId = PROVIDER_ID;
        return AttributeStatementHelper.createAttributeMapper(name, userAttribute, samlAttributeName, nameFormat, friendlyName, consentRequired, consentText, mapperId);
    }

    static {
        ProtocolMapper.ConfigProperty property = new ProtocolMapper.ConfigProperty();
        property.setName("user.attribute");
        property.setLabel("User Property");
        property.setHelpText("Name of the property method in the UserModel interface.  For example, a value of 'email' would reference the UserModel.getEmail() method.");
        configProperties.add(property);
        AttributeStatementHelper.setConfigProperties(configProperties);
    }
}

