/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.protocol.saml.SAML2BindingBuilder2;
import org.keycloak.protocol.saml.SAML2ErrorResponseBuilder;
import org.keycloak.protocol.saml.SAML2LoginResponseBuilder;
import org.keycloak.protocol.saml.SAML2LogoutRequestBuilder;
import org.keycloak.protocol.saml.SAML2LogoutResponseBuilder;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.protocol.saml.mappers.SAMLLoginResponseMapper;
import org.keycloak.protocol.saml.mappers.SAMLRoleListMapper;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.RealmsResource;
import org.w3c.dom.Document;

public class SamlProtocol
implements LoginProtocol {
    protected static final Logger logger = Logger.getLogger(SamlProtocol.class);
    public static final String ATTRIBUTE_TRUE_VALUE = "true";
    public static final String ATTRIBUTE_FALSE_VALUE = "false";
    public static final String SAML_SIGNING_CERTIFICATE_ATTRIBUTE = "saml.signing.certificate";
    public static final String SAML_ENCRYPTION_CERTIFICATE_ATTRIBUTE = "saml.encryption.certificate";
    public static final String SAML_CLIENT_SIGNATURE_ATTRIBUTE = "saml.client.signature";
    public static final String SAML_ASSERTION_CONSUMER_URL_POST_ATTRIBUTE = "saml_assertion_consumer_url_post";
    public static final String SAML_ASSERTION_CONSUMER_URL_REDIRECT_ATTRIBUTE = "saml_assertion_consumer_url_redirect";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE = "saml_single_logout_service_url_post";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE = "saml_single_logout_service_url_redirect";
    public static final String SAML_FORCE_NAME_ID_FORMAT_ATTRIBUTE = "saml_force_name_id_format";
    public static final String SAML_NAME_ID_FORMAT_ATTRIBUTE = "saml_name_id_format";
    public static final String SAML_CANONICALIZATION_METHOD_ATTRIBUTE = "saml_signature_canonicalization_method";
    public static final String LOGIN_PROTOCOL = "saml";
    public static final String SAML_BINDING = "saml_binding";
    public static final String SAML_IDP_INITIATED_LOGIN = "saml_idp_initiated_login";
    public static final String SAML_POST_BINDING = "post";
    public static final String SAML_REDIRECT_BINDING = "get";
    public static final String SAML_SERVER_SIGNATURE = "saml.server.signature";
    public static final String SAML_ASSERTION_SIGNATURE = "saml.assertion.signature";
    public static final String SAML_AUTHNSTATEMENT = "saml.authnstatement";
    public static final String SAML_SIGNATURE_ALGORITHM = "saml.signature.algorithm";
    public static final String SAML_ENCRYPT = "saml.encrypt";
    public static final String SAML_FORCE_POST_BINDING = "saml.force.post.binding";
    public static final String SAML_REQUEST_ID = "SAML_REQUEST_ID";
    public static final String SAML_LOGOUT_BINDING = "saml.logout.binding";
    public static final String SAML_LOGOUT_REQUEST_ID = "SAML_LOGOUT_REQUEST_ID";
    public static final String SAML_LOGOUT_RELAY_STATE = "SAML_LOGOUT_RELAY_STATE";
    public static final String SAML_LOGOUT_CANONICALIZATION = "SAML_LOGOUT_CANONICALIZATION";
    public static final String SAML_LOGOUT_BINDING_URI = "SAML_LOGOUT_BINDING_URI";
    public static final String SAML_LOGOUT_SIGNATURE_ALGORITHM = "saml.logout.signature.algorithm";
    public static final String SAML_NAME_ID = "SAML_NAME_ID";
    public static final String SAML_NAME_ID_FORMAT = "SAML_NAME_ID_FORMAT";
    public static final String SAML_DEFAULT_NAMEID_FORMAT = JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get();
    public static final String SAML_PERSISTENT_NAME_ID_FOR = "saml.persistent.name.id.for";
    public static final String SAML_IDP_INITIATED_SSO_RELAY_STATE = "saml_idp_initiated_sso_relay_state";
    public static final String SAML_IDP_INITIATED_SSO_URL_NAME = "saml_idp_initiated_sso_url_name";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;

    public SamlProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public SamlProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public SamlProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public SamlProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public SamlProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    public Response cancelLogin(ClientSessionModel clientSession) {
        RestartLoginCookie.expireRestartCookie((RealmModel)this.realm, (ClientConnection)this.session.getContext().getConnection(), (UriInfo)this.uriInfo);
        if (ATTRIBUTE_TRUE_VALUE.equals(clientSession.getClient().getAttribute(SAML_IDP_INITIATED_LOGIN))) {
            UriBuilder builder = RealmsResource.protocolUrl((UriInfo)this.uriInfo).path(SamlService.class, "idpInitiatedSSO");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("realm", this.realm.getName());
            params.put("protocol", LOGIN_PROTOCOL);
            params.put("client", clientSession.getClient().getAttribute(SAML_IDP_INITIATED_SSO_URL_NAME));
            this.session.sessions().removeClientSession(this.realm, clientSession);
            URI redirect = builder.buildFromMap(params);
            return Response.status((int)302).location(redirect).build();
        }
        this.session.sessions().removeClientSession(this.realm, clientSession);
        return this.getErrorResponse(clientSession, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
    }

    protected String getResponseIssuer(RealmModel realm) {
        return RealmsResource.realmBaseUrl((UriInfo)this.uriInfo).build(new Object[]{realm.getName()}).toString();
    }

    protected Response getErrorResponse(ClientSessionModel clientSession, String status) {
        SAML2ErrorResponseBuilder builder = ((SAML2ErrorResponseBuilder)((SAML2ErrorResponseBuilder)((SAML2ErrorResponseBuilder)new SAML2ErrorResponseBuilder().relayState(clientSession.getNote("RelayState"))).destination(clientSession.getRedirectUri())).issuer(this.getResponseIssuer(this.realm))).status(status);
        try {
            if (this.isPostBinding(clientSession)) {
                return builder.postBinding().response();
            }
            return builder.redirectBinding().response();
        }
        catch (Exception e) {
            return ErrorPage.error((KeycloakSession)this.session, (String)"failedToProcessResponseMessage", (Object[])new Object[0]);
        }
    }

    protected boolean isPostBinding(ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        return SAML_POST_BINDING.equals(clientSession.getNote(SAML_BINDING)) || SamlProtocol.forcePostBinding(client);
    }

    public static boolean isLogoutPostBindingForInitiator(UserSessionModel session) {
        String note = session.getNote(SAML_LOGOUT_BINDING);
        return SAML_POST_BINDING.equals(note);
    }

    protected boolean isLogoutPostBindingForClient(ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        String logoutPostUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE);
        String logoutRedirectUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE);
        if (logoutPostUrl == null) {
            return logoutRedirectUrl == null;
        }
        if (SamlProtocol.forcePostBinding(client)) {
            return true;
        }
        String bindingType = clientSession.getNote(SAML_BINDING);
        if (SAML_POST_BINDING.equals(bindingType)) {
            return true;
        }
        return logoutRedirectUrl == null;
    }

    public static boolean forcePostBinding(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_FORCE_POST_BINDING));
    }

    protected String getNameIdFormat(ClientSessionModel clientSession) {
        String nameIdFormat = clientSession.getNote("NAMEID_FORMAT");
        ClientModel client = clientSession.getClient();
        boolean forceFormat = SamlProtocol.forceNameIdFormat(client);
        String configuredNameIdFormat = client.getAttribute(SAML_NAME_ID_FORMAT_ATTRIBUTE);
        if ((nameIdFormat == null || forceFormat) && configuredNameIdFormat != null) {
            nameIdFormat = configuredNameIdFormat.equals("email") ? JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get() : (configuredNameIdFormat.equals("persistent") ? JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get() : (configuredNameIdFormat.equals("transient") ? JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get() : (configuredNameIdFormat.equals("username") ? JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get() : JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get())));
        }
        if (nameIdFormat == null) {
            return SAML_DEFAULT_NAMEID_FORMAT;
        }
        return nameIdFormat;
    }

    public static boolean forceNameIdFormat(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_FORCE_NAME_ID_FORMAT_ATTRIBUTE));
    }

    protected String getNameId(String nameIdFormat, ClientSessionModel clientSession, UserSessionModel userSession) {
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
            return userSession.getUser().getEmail();
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get())) {
            return "G-" + UUID.randomUUID().toString();
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get())) {
            String name;
            UserModel user = userSession.getUser();
            String samlPersistentId = user.getFirstAttribute(name = "saml.persistent.name.id.for." + clientSession.getClient().getClientId());
            if (samlPersistentId != null) {
                return samlPersistentId;
            }
            samlPersistentId = "G-" + UUID.randomUUID().toString();
            user.setSingleAttribute(name, samlPersistentId);
            return samlPersistentId;
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get())) {
            return userSession.getUser().getUsername();
        }
        return userSession.getUser().getUsername();
    }

    public Response authenticated(UserSessionModel userSession, ClientSessionCode accessCode) {
        String canonicalization;
        ClientSessionModel clientSession = accessCode.getClientSession();
        ClientModel client = clientSession.getClient();
        String requestID = clientSession.getNote(SAML_REQUEST_ID);
        String relayState = clientSession.getNote("RelayState");
        String redirectUri = clientSession.getRedirectUri();
        String responseIssuer = this.getResponseIssuer(this.realm);
        String nameIdFormat = this.getNameIdFormat(clientSession);
        String nameId = this.getNameId(nameIdFormat, clientSession, userSession);
        clientSession.setNote(SAML_NAME_ID, nameId);
        clientSession.setNote(SAML_NAME_ID_FORMAT, nameIdFormat);
        SAML2LoginResponseBuilder builder = new SAML2LoginResponseBuilder();
        builder.requestID(requestID).destination(redirectUri).issuer(responseIssuer).assertionExpiration(this.realm.getAccessCodeLifespan()).subjectExpiration(this.realm.getAccessTokenLifespan()).sessionIndex(clientSession.getId()).requestIssuer(clientSession.getClient().getClientId()).nameIdentifier(nameIdFormat, nameId).authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get());
        if (!SamlProtocol.includeAuthnStatement(client)) {
            builder.disableAuthnStatement(true);
        }
        LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers = new LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>>();
        LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>> loginResponseMappers = new LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>>();
        ProtocolMapperProcessor<SAMLRoleListMapper> roleListMapper = null;
        Set mappings = accessCode.getRequestedProtocolMappers();
        for (ProtocolMapperModel mapping : mappings) {
            ProtocolMapper mapper = (ProtocolMapper)this.session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
            if (mapper == null) continue;
            if (mapper instanceof SAMLAttributeStatementMapper) {
                attributeStatementMappers.add(new ProtocolMapperProcessor<SAMLAttributeStatementMapper>((SAMLAttributeStatementMapper)mapper, mapping));
            }
            if (mapper instanceof SAMLLoginResponseMapper) {
                loginResponseMappers.add(new ProtocolMapperProcessor<SAMLLoginResponseMapper>((SAMLLoginResponseMapper)mapper, mapping));
            }
            if (!(mapper instanceof SAMLRoleListMapper)) continue;
            roleListMapper = new ProtocolMapperProcessor<SAMLRoleListMapper>((SAMLRoleListMapper)mapper, mapping);
        }
        Document samlDocument = null;
        try {
            ResponseType samlModel = builder.buildModel();
            this.transformAttributeStatement(attributeStatementMappers, samlModel, this.session, userSession, clientSession);
            this.populateRoles(roleListMapper, samlModel, this.session, userSession, clientSession);
            samlModel = this.transformLoginResponse(loginResponseMappers, samlModel, this.session, userSession, clientSession);
            samlDocument = builder.buildDocument(samlModel);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error((KeycloakSession)this.session, (String)"failedToProcessResponseMessage", (Object[])new Object[0]);
        }
        SAML2BindingBuilder2 bindingBuilder = new SAML2BindingBuilder2();
        bindingBuilder.relayState(relayState);
        if (SamlProtocol.requiresRealmSignature(client)) {
            canonicalization = client.getAttribute(SAML_CANONICALIZATION_METHOD_ATTRIBUTE);
            if (canonicalization != null) {
                bindingBuilder.canonicalizationMethod(canonicalization);
            }
            ((SAML2BindingBuilder2)((SAML2BindingBuilder2)bindingBuilder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signDocument();
        }
        if (SamlProtocol.requiresAssertionSignature(client)) {
            canonicalization = client.getAttribute(SAML_CANONICALIZATION_METHOD_ATTRIBUTE);
            if (canonicalization != null) {
                bindingBuilder.canonicalizationMethod(canonicalization);
            }
            ((SAML2BindingBuilder2)((SAML2BindingBuilder2)bindingBuilder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signAssertions();
        }
        if (this.requiresEncryption(client)) {
            PublicKey publicKey = null;
            try {
                publicKey = SamlProtocolUtils.getEncryptionValidationKey(client);
            }
            catch (Exception e) {
                logger.error((Object)"failed", (Throwable)e);
                return ErrorPage.error((KeycloakSession)this.session, (String)"failedToProcessResponseMessage", (Object[])new Object[0]);
            }
            bindingBuilder.encrypt(publicKey);
        }
        try {
            if (this.isPostBinding(clientSession)) {
                return bindingBuilder.postBinding(samlDocument).response(redirectUri);
            }
            return bindingBuilder.redirectBinding(samlDocument).response(redirectUri);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error((KeycloakSession)this.session, (String)"failedToProcessResponseMessage", (Object[])new Object[0]);
        }
    }

    public static boolean requiresRealmSignature(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_SERVER_SIGNATURE));
    }

    public static boolean requiresAssertionSignature(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_ASSERTION_SIGNATURE));
    }

    public static boolean includeAuthnStatement(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_AUTHNSTATEMENT));
    }

    public static SignatureAlgorithm getSignatureAlgorithm(ClientModel client) {
        SignatureAlgorithm algorithm;
        String alg = client.getAttribute(SAML_SIGNATURE_ALGORITHM);
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf(alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    private boolean requiresEncryption(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_ENCRYPT));
    }

    public void transformAttributeStatement(List<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers, ResponseType response, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        AssertionType assertion = ((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion();
        AttributeStatementType attributeStatement = new AttributeStatementType();
        for (ProtocolMapperProcessor<SAMLAttributeStatementMapper> processor : attributeStatementMappers) {
            ((SAMLAttributeStatementMapper)processor.mapper).transformAttributeStatement(attributeStatement, processor.model, session, userSession, clientSession);
        }
        if (attributeStatement.getAttributes().size() > 0) {
            assertion.addStatement((StatementAbstractType)attributeStatement);
        }
    }

    public ResponseType transformLoginResponse(List<ProtocolMapperProcessor<SAMLLoginResponseMapper>> mappers, ResponseType response, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        for (ProtocolMapperProcessor<SAMLLoginResponseMapper> processor : mappers) {
            response = ((SAMLLoginResponseMapper)processor.mapper).transformLoginResponse(response, processor.model, session, userSession, clientSession);
        }
        return response;
    }

    public void populateRoles(ProtocolMapperProcessor<SAMLRoleListMapper> roleListMapper, ResponseType response, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (roleListMapper == null) {
            return;
        }
        AssertionType assertion = ((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion();
        AttributeStatementType attributeStatement = new AttributeStatementType();
        assertion.addStatement((StatementAbstractType)attributeStatement);
        ((SAMLRoleListMapper)roleListMapper.mapper).mapRoles(attributeStatement, roleListMapper.model, session, userSession, clientSession);
    }

    public Response consentDenied(ClientSessionModel clientSession) {
        RestartLoginCookie.expireRestartCookie((RealmModel)this.realm, (ClientConnection)this.session.getContext().getConnection(), (UriInfo)this.uriInfo);
        if (ATTRIBUTE_TRUE_VALUE.equals(clientSession.getClient().getAttribute(SAML_IDP_INITIATED_LOGIN))) {
            this.session.sessions().removeClientSession(this.realm, clientSession);
            return ErrorPage.error((KeycloakSession)this.session, (String)"consentDenied", (Object[])new Object[0]);
        }
        this.session.sessions().removeClientSession(this.realm, clientSession);
        return this.getErrorResponse(clientSession, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
    }

    public static String getLogoutServiceUrl(UriInfo uriInfo, ClientModel client, String bindingType) {
        String logoutServiceUrl = null;
        logoutServiceUrl = SAML_POST_BINDING.equals(bindingType) ? client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE) : client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE);
        if (logoutServiceUrl == null && client instanceof ClientModel) {
            logoutServiceUrl = client.getManagementUrl();
        }
        if (logoutServiceUrl == null || logoutServiceUrl.trim().equals("")) {
            return null;
        }
        return ResourceAdminManager.resolveUri((URI)uriInfo.getRequestUri(), (String)logoutServiceUrl);
    }

    public Response frontchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        if (!(client instanceof ClientModel)) {
            return null;
        }
        try {
            if (this.isLogoutPostBindingForClient(clientSession)) {
                String bindingUri = SamlProtocol.getLogoutServiceUrl(this.uriInfo, client, SAML_POST_BINDING);
                SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(bindingUri, clientSession, client);
                return logoutBuilder.postBinding().request(bindingUri);
            }
            logger.debug((Object)"frontchannel redirect binding");
            String bindingUri = SamlProtocol.getLogoutServiceUrl(this.uriInfo, client, SAML_REDIRECT_BINDING);
            SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(bindingUri, clientSession, client);
            return logoutBuilder.redirectBinding().request(bindingUri);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public Response finishLogout(UserSessionModel userSession) {
        logger.debug((Object)"finishLogout");
        String logoutBindingUri = userSession.getNote(SAML_LOGOUT_BINDING_URI);
        if (logoutBindingUri == null) {
            logger.error((Object)"Can't finish SAML logout as there is no logout binding set");
            return ErrorPage.error((KeycloakSession)this.session, (String)"failedLogout", (Object[])new Object[0]);
        }
        String logoutRelayState = userSession.getNote(SAML_LOGOUT_RELAY_STATE);
        SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
        builder.logoutRequestID(userSession.getNote(SAML_LOGOUT_REQUEST_ID));
        builder.destination(logoutBindingUri);
        builder.issuer(this.getResponseIssuer(this.realm));
        builder.relayState(logoutRelayState);
        String signingAlgorithm = userSession.getNote(SAML_LOGOUT_SIGNATURE_ALGORITHM);
        if (signingAlgorithm != null) {
            SignatureAlgorithm algorithm = SignatureAlgorithm.valueOf(signingAlgorithm);
            String canonicalization = userSession.getNote(SAML_LOGOUT_CANONICALIZATION);
            if (canonicalization != null) {
                builder.canonicalizationMethod(canonicalization);
            }
            ((SAML2LogoutResponseBuilder)((SAML2LogoutResponseBuilder)builder.signatureAlgorithm(algorithm)).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signDocument();
        }
        try {
            if (SamlProtocol.isLogoutPostBindingForInitiator(userSession)) {
                return builder.postBinding().response(logoutBindingUri);
            }
            return builder.redirectBinding().response(logoutBindingUri);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        String logoutUrl = SamlProtocol.getLogoutServiceUrl(this.uriInfo, client, SAML_POST_BINDING);
        if (logoutUrl == null) {
            logger.warnv("Can't do backchannel logout. No SingleLogoutService POST Binding registered for client: {1}", (Object)client.getClientId());
            return;
        }
        SAML2LogoutRequestBuilder logoutBuilder = this.createLogoutRequest(logoutUrl, clientSession, client);
        String logoutRequestString = null;
        try {
            logoutRequestString = logoutBuilder.postBinding().encoded();
        }
        catch (Exception e) {
            logger.warn((Object)"failed to send saml logout", (Throwable)e);
            return;
        }
        HttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        for (int i = 0; i < 2; ++i) {
            try {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                formparams.add(new BasicNameValuePair("SAMLRequest", logoutRequestString));
                formparams.add(new BasicNameValuePair("BACK_CHANNEL_LOGOUT", "BACK_CHANNEL_LOGOUT"));
                UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
                HttpPost post = new HttpPost(logoutUrl);
                post.setEntity((HttpEntity)form);
                HttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 302 || logoutUrl.endsWith("/")) break;
                    String redirect = response.getFirstHeader("Location").getValue();
                    String withSlash = logoutUrl + "/";
                    if (!withSlash.equals(redirect)) break;
                    logoutUrl = withSlash;
                    continue;
                }
                finally {
                    InputStream is;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (is = entity.getContent()) != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)"failed to send saml logout", (Throwable)e);
                break;
            }
        }
    }

    protected SAML2LogoutRequestBuilder createLogoutRequest(String logoutUrl, ClientSessionModel clientSession, ClientModel client) {
        SAML2LogoutRequestBuilder logoutBuilder = (SAML2LogoutRequestBuilder)((SAML2LogoutRequestBuilder)new SAML2LogoutRequestBuilder().assertionExpiration(this.realm.getAccessCodeLifespan()).issuer(this.getResponseIssuer(this.realm))).userPrincipal(clientSession.getNote(SAML_NAME_ID), clientSession.getNote(SAML_NAME_ID_FORMAT)).destination(logoutUrl);
        if (SamlProtocol.requiresRealmSignature(client)) {
            ((SAML2LogoutRequestBuilder)((SAML2LogoutRequestBuilder)logoutBuilder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signDocument();
        }
        return logoutBuilder;
    }

    public void close() {
    }

    public static class ProtocolMapperProcessor<T> {
        public final T mapper;
        public final ProtocolMapperModel model;

        public ProtocolMapperProcessor(T mapper, ProtocolMapperModel model) {
            this.mapper = mapper;
            this.model = model;
        }
    }
}

