/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class GroupMembershipMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    public static final String PROVIDER_ID = "saml-group-membership-mapper";
    public static final String SINGLE_GROUP_ATTRIBUTE = "single";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getDisplayCategory() {
        return "Group Mapper";
    }

    public String getDisplayType() {
        return "Group list";
    }

    public String getHelpText() {
        return "Group names are stored in an attribute value.  There is either one attribute with multiple attribute values, or an attribute per group name depending on how you configure it.  You can also specify the attribute name i.e. 'member' or 'memberOf' being examples.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public static boolean useFullPath(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get("full.path"));
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        String single = (String)mappingModel.getConfig().get(SINGLE_GROUP_ATTRIBUTE);
        boolean singleAttribute = Boolean.parseBoolean(single);
        boolean fullPath = GroupMembershipMapper.useFullPath(mappingModel);
        AttributeType singleAttributeType = null;
        for (GroupModel group : userSession.getUser().getGroups()) {
            String groupName = fullPath ? ModelToRepresentation.buildGroupPath((GroupModel)group) : group.getName();
            AttributeType attributeType = null;
            if (singleAttribute) {
                if (singleAttributeType == null) {
                    singleAttributeType = AttributeStatementHelper.createAttributeType(mappingModel);
                    attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(singleAttributeType));
                }
                attributeType = singleAttributeType;
            } else {
                attributeType = AttributeStatementHelper.createAttributeType(mappingModel);
                attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attributeType));
            }
            attributeType.addAttributeValue((Object)groupName);
        }
    }

    public static ProtocolMapperModel create(String name, String samlAttributeName, String nameFormat, String friendlyName, boolean singleAttribute) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("saml");
        mapper.setConsentRequired(false);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("attribute.name", samlAttributeName);
        if (friendlyName != null) {
            config.put("friendly.name", friendlyName);
        }
        if (nameFormat != null) {
            config.put("attribute.nameformat", nameFormat);
        }
        config.put(SINGLE_GROUP_ATTRIBUTE, Boolean.toString(singleAttribute));
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("attribute.name");
        property.setLabel("Group attribute name");
        property.setDefaultValue((Object)"member");
        property.setHelpText("Name of the SAML attribute you want to put your groups into.  i.e. 'member', 'memberOf'.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("friendly.name");
        property.setLabel("Friendly Name");
        property.setHelpText("Standard SAML attribute setting.  An optional, more human-readable form of the attribute's name that can be provided if the actual attribute name is cryptic.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("attribute.nameformat");
        property.setLabel("SAML Attribute NameFormat");
        property.setHelpText("SAML Attribute NameFormat.  Can be basic, URI reference, or unspecified.");
        ArrayList<String> types = new ArrayList<String>(3);
        types.add("Basic");
        types.add("URI Reference");
        types.add("Unspecified");
        property.setType("List");
        property.setDefaultValue(types);
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(SINGLE_GROUP_ATTRIBUTE);
        property.setLabel("Single Group Attribute");
        property.setType("boolean");
        property.setDefaultValue((Object)"true");
        property.setHelpText("If true, all groups will be stored under one attribute with multiple attribute values.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("full.path");
        property.setLabel("Full group path");
        property.setType("boolean");
        property.setDefaultValue((Object)"true");
        property.setHelpText("Include full path to group i.e. /top/level1/level2, false will just specify the group name");
        configProperties.add(property);
    }
}

