/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.regex.Pattern;

public class PathHelper {
    public static final String URI_PARAM_NAME_REGEX = "\\w[\\w\\.-]*";
    public static final String URI_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    public static final String URI_PARAM_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}";
    public static final Pattern URI_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}");
    public static final Pattern URI_TEMPLATE_PATTERN = Pattern.compile("(\\{([^}]+)\\})");
    public static final char openCurlyReplacement = '\u0006';
    public static final char closeCurlyReplacement = '\u0007';

    public static String replaceEnclosedCurlyBraces(String str) {
        char[] chars = str.toCharArray();
        int open = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                if (open != 0) {
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (chars[i] != '}' || --open == 0) continue;
            chars[i] = 7;
        }
        return new String(chars);
    }

    public static String recoverEnclosedCurlyBraces(String str) {
        return str.replace('\u0006', '{').replace('\u0007', '}');
    }
}

