/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.saml.v2.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.ActionType;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextClassRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.AuthzDecisionStatementType;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.DecisionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.EvidenceType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.exceptions.fed.IssueInstantMissingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.keycloak.saml.processing.core.saml.v2.factories.SAMLAssertionFactory;
import org.keycloak.saml.processing.core.saml.v2.holders.IDPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.SPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;
import org.keycloak.saml.processing.core.util.JAXPValidationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2Response {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final long ASSERTION_VALIDITY = 5000L;
    private final long CLOCK_SKEW = 2000L;
    private SAMLDocumentHolder samlDocumentHolder = null;

    public AssertionType createAssertion(String id, NameIDType issuer) {
        return AssertionUtil.createAssertion(id, issuer);
    }

    public AuthnStatementType createAuthnStatement(String authnContextDeclRef, XMLGregorianCalendar issueInstant) {
        AuthnStatementType authnStatement = new AuthnStatementType(issueInstant);
        AuthnContextType act = new AuthnContextType();
        String authContextDeclRef = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
        act.addAuthenticatingAuthority(URI.create(authContextDeclRef));
        AuthnContextType.AuthnContextTypeSequence sequence = new AuthnContextType.AuthnContextTypeSequence(act);
        sequence.setClassRef(new AuthnContextClassRefType(JBossSAMLURIConstants.AC_PASSWORD.getUri()));
        act.setSequence(sequence);
        authnStatement.setAuthnContext(act);
        return authnStatement;
    }

    public AuthzDecisionStatementType createAuthzDecisionStatementType(String resource, DecisionType decision, EvidenceType evidence, ActionType ... actions) {
        AuthzDecisionStatementType authzDecST = new AuthzDecisionStatementType();
        authzDecST.setResource(resource);
        authzDecST.setDecision(decision);
        if (evidence != null) {
            authzDecST.setEvidence(evidence);
        }
        if (actions != null) {
            authzDecST.getAction().addAll(Arrays.asList(actions));
        }
        return authzDecST;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException, ProcessingException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID((BaseIDAbstractType)nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        ConditionsType conditions = assertion.getConditions();
        if (conditions != null) {
            subjectConfirmationData.setNotOnOrAfter(conditions.getNotOnOrAfter());
            AudienceRestrictionType audience = new AudienceRestrictionType();
            audience.addAudience(URI.create(sp.getResponseDestinationURI()));
            conditions.addCondition((ConditionAbstractType)audience);
        }
        ResponseType responseType = this.createResponseType(ID, issuerInfo, assertion);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException, ProcessingException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(idp.getNameIDFormat() == null ? null : URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID((BaseIDAbstractType)nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        NameIDType issuerID = issuerInfo.getIssuer();
        try {
            issueInstant = XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        ConditionsType conditions = null;
        LinkedList<StatementAbstractType> statements = new LinkedList<StatementAbstractType>();
        String assertionID = IDGenerator.create("ID_");
        AssertionType assertionType = SAMLAssertionFactory.createAssertion(assertionID, issuerID, issueInstant, conditions, subjectType, statements);
        try {
            AssertionUtil.createTimedConditions(assertionType, 5000L, 2000L);
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        catch (IssueInstantMissingException e) {
            throw logger.processingError(e);
        }
        ResponseType responseType = this.createResponseType(ID, issuerInfo, assertionType);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public ResponseType createResponseType(String ID) {
        try {
            return new ResponseType(ID, XMLTimeUtil.getIssueInstant());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertion);
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, Element encryptedAssertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, encryptedAssertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws ConfigurationException, IssueInstantMissingException {
        AssertionUtil.createTimedConditions(assertion, durationInMilis);
    }

    public EncryptedAssertionType getEncryptedAssertion(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = SAMLParser.getInstance();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        return (EncryptedAssertionType)samlParser.parse(samlDocument);
    }

    public AssertionType getAssertionType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = SAMLParser.getInstance();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        return (AssertionType)samlParser.parse(samlDocument);
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public ResponseType getResponseType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlResponseDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = SAMLParser.getInstance();
        JAXPValidationUtil.checkSchemaValidation(samlResponseDocument);
        ResponseType responseType = (ResponseType)samlParser.parse(samlResponseDocument);
        this.samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)responseType, samlResponseDocument);
        return responseType;
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlResponseDocument = DocumentUtil.getDocument(is);
        if (logger.isTraceEnabled()) {
            logger.trace("SAML Response Document: " + DocumentUtil.asString(samlResponseDocument));
        }
        SAMLParser samlParser = SAMLParser.getInstance();
        JAXPValidationUtil.checkSchemaValidation(samlResponseDocument);
        SAML2Object responseType = (SAML2Object)samlParser.parse(samlResponseDocument);
        this.samlDocumentHolder = new SAMLDocumentHolder(responseType, samlResponseDocument);
        return responseType;
    }

    public Document convert(EncryptedElementType encryptedElementType) throws ConfigurationException {
        if (encryptedElementType == null) {
            throw logger.nullArgumentError("encryptedElementType");
        }
        Document doc = DocumentUtil.createDocument();
        Node importedNode = doc.importNode(encryptedElementType.getEncryptedElement(), true);
        doc.appendChild(importedNode);
        return doc;
    }

    public Document convert(StatusResponseType responseType) throws ProcessingException, ConfigurationException, ParsingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SAMLResponseWriter writer = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(bos));
        if (responseType instanceof ResponseType) {
            ResponseType response = (ResponseType)responseType;
            writer.write(response);
        } else {
            writer.write(responseType, new QName(JBossSAMLURIConstants.PROTOCOL_NSURI.get(), JBossSAMLConstants.LOGOUT_RESPONSE.get(), "samlp"));
        }
        return DocumentUtil.getDocument(new ByteArrayInputStream(bos.toByteArray()));
    }

    public void marshall(ResponseType responseType, OutputStream os) throws ProcessingException {
        SAMLResponseWriter samlWriter = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(os));
        samlWriter.write(responseType);
    }

    public void marshall(ResponseType responseType, Writer writer) throws ProcessingException {
        SAMLResponseWriter samlWriter = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(writer));
        samlWriter.write(responseType);
    }
}

