/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.adapters.saml.config.IDP;
import org.keycloak.adapters.saml.config.parsers.KeysXmlParser;
import org.keycloak.adapters.saml.config.parsers.SPXmlParser;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public class IDPXmlParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"IDP");
        IDP idp = new IDP();
        String entityID = SPXmlParser.getAttributeValue(startElement, "entityID");
        if (entityID == null) {
            throw new ParsingException("entityID must be set on IDP");
        }
        idp.setEntityID(entityID);
        boolean signaturesRequired = SPXmlParser.getBooleanAttributeValue(startElement, "signaturesRequired");
        idp.setSignatureCanonicalizationMethod(SPXmlParser.getAttributeValue(startElement, "signatureCanonicalizationMethod"));
        idp.setSignatureAlgorithm(SPXmlParser.getAttributeValue(startElement, "signatureAlgorithm"));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals("IDP")) continue;
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("SingleSignOnService")) {
                IDP.SingleSignOnService sso = this.parseSingleSignOnService(xmlEventReader, signaturesRequired);
                idp.setSingleSignOnService(sso);
                continue;
            }
            if (tag.equals("SingleLogoutService")) {
                IDP.SingleLogoutService slo = this.parseSingleLogoutService(xmlEventReader, signaturesRequired);
                idp.setSingleLogoutService(slo);
                continue;
            }
            if (tag.equals("Keys")) {
                KeysXmlParser parser = new KeysXmlParser();
                List keys = (List)parser.parse(xmlEventReader);
                idp.setKeys(keys);
                continue;
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        return idp;
    }

    protected IDP.SingleLogoutService parseSingleLogoutService(XMLEventReader xmlEventReader, boolean signaturesRequired) throws ParsingException {
        IDP.SingleLogoutService slo = new IDP.SingleLogoutService();
        StartElement element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        slo.setSignRequest(SPXmlParser.getBooleanAttributeValue(element, "signRequest", signaturesRequired));
        slo.setValidateResponseSignature(SPXmlParser.getBooleanAttributeValue(element, "validateResponseSignature", signaturesRequired));
        slo.setValidateRequestSignature(SPXmlParser.getBooleanAttributeValue(element, "validateRequestSignature", signaturesRequired));
        slo.setRequestBinding(SPXmlParser.getAttributeValue(element, "requestBinding"));
        slo.setResponseBinding(SPXmlParser.getAttributeValue(element, "responseBinding"));
        slo.setSignResponse(SPXmlParser.getBooleanAttributeValue(element, "signResponse", signaturesRequired));
        slo.setPostBindingUrl(SPXmlParser.getAttributeValue(element, "postBindingUrl"));
        slo.setRedirectBindingUrl(SPXmlParser.getAttributeValue(element, "redirectBindingUrl"));
        return slo;
    }

    protected IDP.SingleSignOnService parseSingleSignOnService(XMLEventReader xmlEventReader, boolean signaturesRequired) throws ParsingException {
        IDP.SingleSignOnService sso = new IDP.SingleSignOnService();
        StartElement element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        sso.setSignRequest(SPXmlParser.getBooleanAttributeValue(element, "signRequest", signaturesRequired));
        sso.setValidateResponseSignature(SPXmlParser.getBooleanAttributeValue(element, "validateResponseSignature", signaturesRequired));
        sso.setRequestBinding(SPXmlParser.getAttributeValue(element, "requestBinding"));
        sso.setResponseBinding(SPXmlParser.getAttributeValue(element, "responseBinding"));
        sso.setBindingUrl(SPXmlParser.getAttributeValue(element, "bindingUrl"));
        return sso;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

