/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.profile.webbrowsersso;

import org.keycloak.adapters.saml.OnSessionCreated;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.saml.profile.AbstractSamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.SamlInvocationContext;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;

public class WebBrowserSsoAuthenticationHandler
extends AbstractSamlAuthenticationHandler {
    public static SamlAuthenticationHandler create(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        return new WebBrowserSsoAuthenticationHandler(facade, deployment, sessionStore);
    }

    WebBrowserSsoAuthenticationHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        super(facade, deployment, sessionStore);
    }

    @Override
    public AuthOutcome handle(OnSessionCreated onCreateSession) {
        return this.doHandle(new SamlInvocationContext(this.facade.getRequest().getFirstParam("SAMLRequest"), this.facade.getRequest().getFirstParam("SAMLResponse"), this.facade.getRequest().getFirstParam("RelayState")), onCreateSession);
    }

    @Override
    protected AuthOutcome handleRequest() {
        boolean globalLogout = "true".equals(this.facade.getRequest().getQueryParamValue("GLO"));
        if (globalLogout) {
            return this.globalLogout();
        }
        return AuthOutcome.AUTHENTICATED;
    }

    @Override
    protected AuthOutcome logoutRequest(LogoutRequestType request, String relayState) {
        if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
            this.sessionStore.logoutByPrincipal(request.getNameID().getValue());
        } else {
            this.sessionStore.logoutBySsoId(request.getSessionIndex());
        }
        String issuerURL = this.deployment.getEntityID();
        SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
        builder.logoutRequestID(request.getID());
        builder.destination(this.deployment.getIDP().getSingleLogoutService().getResponseBindingUrl());
        builder.issuer(issuerURL);
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder().relayState(relayState);
        if (this.deployment.getIDP().getSingleLogoutService().signResponse()) {
            if (this.deployment.getSignatureCanonicalizationMethod() != null) {
                binding.canonicalizationMethod(this.deployment.getSignatureCanonicalizationMethod());
            }
            binding.signatureAlgorithm(this.deployment.getSignatureAlgorithm()).signWith(this.deployment.getSigningKeyPair()).signDocument();
        }
        try {
            SamlUtil.sendSaml(false, this.facade, this.deployment.getIDP().getSingleLogoutService().getResponseBindingUrl(), binding, builder.buildDocument(), this.deployment.getIDP().getSingleLogoutService().getResponseBinding());
        }
        catch (Exception e) {
            log.error((Object)"Could not send logout response SAML request", (Throwable)e);
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.NOT_ATTEMPTED;
    }

    private AuthOutcome globalLogout() {
        SamlSession account = this.sessionStore.getAccount();
        if (account == null) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(30).issuer(this.deployment.getEntityID()).sessionIndex(account.getSessionIndex()).userPrincipal(account.getPrincipal().getSamlSubject(), account.getPrincipal().getNameIDFormat()).destination(this.deployment.getIDP().getSingleLogoutService().getRequestBindingUrl());
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
        if (this.deployment.getIDP().getSingleLogoutService().signRequest()) {
            if (this.deployment.getSignatureCanonicalizationMethod() != null) {
                binding.canonicalizationMethod(this.deployment.getSignatureCanonicalizationMethod());
            }
            binding.signatureAlgorithm(this.deployment.getSignatureAlgorithm());
            binding.signWith(this.deployment.getSigningKeyPair()).signDocument();
        }
        binding.relayState("logout");
        try {
            SamlUtil.sendSaml(true, this.facade, this.deployment.getIDP().getSingleLogoutService().getRequestBindingUrl(), binding, logoutBuilder.buildDocument(), this.deployment.getIDP().getSingleLogoutService().getRequestBinding());
            this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.LOGGING_OUT);
        }
        catch (Exception e) {
            log.error((Object)"Could not send global logout SAML request", (Throwable)e);
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.NOT_ATTEMPTED;
    }
}

