/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import javax.security.auth.callback.CallbackHandler;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.elytron.ElytronHttpFacade;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.webbrowsersso.BrowserHandler;
import org.keycloak.adapters.spi.HttpFacade;

public class ElytronSamlAuthenticator
extends SamlAuthenticator {
    private final CallbackHandler callbackHandler;
    private final ElytronHttpFacade facade;

    public ElytronSamlAuthenticator(ElytronHttpFacade facade, SamlDeployment samlDeployment, CallbackHandler callbackHandler) {
        super((HttpFacade)facade, samlDeployment, facade.getSessionStore());
        this.callbackHandler = callbackHandler;
        this.facade = facade;
    }

    protected void completeAuthentication(SamlSession samlSession) {
        this.facade.authenticationComplete(samlSession);
    }

    protected SamlAuthenticationHandler createBrowserHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        return new BrowserHandler(facade, deployment, sessionStore);
    }
}

