/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.adapters.cloned.AdapterHttpClientConfig;
import org.keycloak.adapters.saml.config.IDP;
import org.keycloak.adapters.saml.config.parsers.AbstractKeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.HttpClientParser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.adapters.saml.config.parsers.KeysParser;
import org.keycloak.adapters.saml.config.parsers.SingleLogoutServiceParser;
import org.keycloak.adapters.saml.config.parsers.SingleSignOnServiceParser;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class IdpParser
extends AbstractKeycloakSamlAdapterV1Parser<IDP> {
    private static final IdpParser INSTANCE = new IdpParser();

    private IdpParser() {
        super(KeycloakSamlAdapterV1QNames.IDP);
    }

    public static IdpParser getInstance() {
        return INSTANCE;
    }

    protected IDP instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        IDP idp = new IDP();
        idp.setEntityID(StaxParserUtil.getRequiredAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ENTITY_ID));
        Boolean signaturesRequired = StaxParserUtil.getBooleanAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SIGNATURES_REQUIRED);
        idp.setSignaturesRequired(signaturesRequired == null ? false : signaturesRequired);
        idp.setSignatureCanonicalizationMethod(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SIGNATURE_CANONICALIZATION_METHOD));
        idp.setSignatureAlgorithm(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_SIGNATURE_ALGORITHM));
        idp.setMetadataUrl(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_METADATA_URL));
        return idp;
    }

    protected void processSubElement(XMLEventReader xmlEventReader, IDP target, KeycloakSamlAdapterV1QNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case HTTP_CLIENT: {
                target.setHttpClientConfig((AdapterHttpClientConfig)HttpClientParser.getInstance().parse(xmlEventReader));
                break;
            }
            case KEYS: {
                target.setKeys((List)KeysParser.getInstance().parse(xmlEventReader));
                break;
            }
            case SINGLE_SIGN_ON_SERVICE: {
                target.setSingleSignOnService((IDP.SingleSignOnService)SingleSignOnServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case SINGLE_LOGOUT_SERVICE: {
                target.setSingleLogoutService((IDP.SingleLogoutService)SingleLogoutServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ALLOWED_CLOCK_SKEW: {
                String timeUnitString = StaxParserUtil.getAttributeValueRP((StartElement)elementDetail, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_UNIT);
                target.setAllowedClockSkewUnit(timeUnitString == null ? TimeUnit.SECONDS : TimeUnit.valueOf(timeUnitString));
                StaxParserUtil.advance((XMLEventReader)xmlEventReader);
                target.setAllowedClockSkew(Integer.parseInt(StaxParserUtil.getElementTextRP((XMLEventReader)xmlEventReader)));
            }
        }
    }
}

