/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.util.SecurityActions;

public class StringUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final Pattern PROPERTY_REPLACEMENT = Pattern.compile("(.*?)\\$\\{(.*?)(?:::(.*?))?\\}");

    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getSystemPropertyAsString(String str) {
        if (str == null) {
            throw logger.nullArgumentError("str");
        }
        Matcher m = PROPERTY_REPLACEMENT.matcher(str);
        StringBuilder sb = new StringBuilder();
        int lastPosition = 0;
        while (m.find()) {
            String defaultValue;
            String propertyName = m.group(2);
            String sysPropertyValue = SecurityActions.getSystemProperty(propertyName, defaultValue = m.group(3));
            if (sysPropertyValue.isEmpty()) {
                throw logger.systemPropertyMissingError(propertyName);
            }
            sb.append(m.group(1)).append(sysPropertyValue);
            lastPosition = m.end();
        }
        return sb.append(str.substring(lastPosition)).toString();
    }

    public static void match(String first, String second) {
        if (!first.equals(second)) {
            throw logger.notEqualError(first, second);
        }
    }

    public static List<String> tokenize(String str) {
        return StringUtil.tokenize(str, ",");
    }

    public static List<String> tokenize(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static Map<String, String> tokenizeKeyValuePair(String keyValuePairString) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> tokens = StringUtil.tokenize(keyValuePairString);
        for (String token : tokens) {
            int location = token.indexOf(61);
            map.put(token.substring(0, location), token.substring(location + 1));
        }
        return map;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter can only be one character in length");
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + 1);
        return new String[]{beforeDelimiter, afterDelimiter};
    }
}

