/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.wildfly.infinispan;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.TransactionalEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.logging.Logger;
import org.keycloak.adapters.spi.SessionIdMapper;

@Listener
public class SsoSessionCacheListener {
    private static final Logger LOG = Logger.getLogger(SsoSessionCacheListener.class);
    private final ConcurrentMap<String, Queue<Event>> map = new ConcurrentHashMap<String, Queue<Event>>();
    private final SessionIdMapper idMapper;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public SsoSessionCacheListener(SessionIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    @TransactionRegistered
    public void startTransaction(TransactionRegisteredEvent event) {
        this.map.put(event.getGlobalTransaction().globalId(), new ConcurrentLinkedQueue());
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        this.executor.shutdownNow();
    }

    @CacheEntryCreated
    @CacheEntryRemoved
    public void addEvent(TransactionalEvent event) {
        if (!event.isPre()) {
            ((Queue)this.map.get(event.getGlobalTransaction().globalId())).add(event);
        }
    }

    @TransactionCompleted
    public void endTransaction(TransactionCompletedEvent event) {
        Queue events = (Queue)this.map.remove(event.getGlobalTransaction().globalId());
        if (events == null || !event.isTransactionSuccessful()) {
            return;
        }
        if (event.isOriginLocal()) {
            return;
        }
        for (final Event e : events) {
            switch (e.getType()) {
                case CACHE_ENTRY_CREATED: {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            SsoSessionCacheListener.this.cacheEntryCreated((CacheEntryCreatedEvent)e);
                        }
                    });
                    break;
                }
                case CACHE_ENTRY_REMOVED: {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            SsoSessionCacheListener.this.cacheEntryRemoved((CacheEntryRemovedEvent)e);
                        }
                    });
                }
            }
        }
    }

    private void cacheEntryCreated(CacheEntryCreatedEvent event) {
        if (!(event.getKey() instanceof String) || !(event.getValue() instanceof String[])) {
            return;
        }
        String httpSessionId = (String)event.getKey();
        String[] value = (String[])event.getValue();
        String ssoId = value[0];
        String principal = value[1];
        LOG.tracev("cacheEntryCreated {0}:{1}", (Object)httpSessionId, (Object)ssoId);
        this.idMapper.map(ssoId, principal, httpSessionId);
    }

    private void cacheEntryRemoved(CacheEntryRemovedEvent event) {
        if (!(event.getKey() instanceof String)) {
            return;
        }
        LOG.tracev("cacheEntryRemoved {0}", event.getKey());
        this.idMapper.removeSession((String)event.getKey());
    }
}

