/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.util;

import java.security.cert.X509Certificate;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public class KeyInfoTools {
    public static <T> T getContent(Iterable<Object> objects, Class<T> clazz) {
        if (objects == null) {
            return null;
        }
        for (Object o : objects) {
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public static KeyName getKeyName(KeyInfo keyInfo) {
        return keyInfo == null ? null : KeyInfoTools.getContent(keyInfo.getContent(), KeyName.class);
    }

    public static X509Data getX509Data(KeyInfo keyInfo) {
        return keyInfo == null ? null : KeyInfoTools.getContent(keyInfo.getContent(), X509Data.class);
    }

    public static X509Certificate getX509Certificate(KeyInfo keyInfo) {
        X509Data d = KeyInfoTools.getX509Data(keyInfo);
        return d == null ? null : KeyInfoTools.getContent(d.getContent(), X509Certificate.class);
    }
}

