/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import java.util.ArrayList;
import java.util.Objects;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.keycloak.subsystem.adapter.saml.extension.Configuration;

public class KeycloakClusteredSsoDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger LOG = Logger.getLogger(KeycloakClusteredSsoDeploymentProcessor.class);
    private static final String DEFAULT_CACHE_CONTAINER = "web";
    private static final String SSO_CACHE_CONTAINER_NAME_PARAM_NAME = "keycloak.sessionIdMapperUpdater.infinispan.containerName";
    private static final String SSO_CACHE_NAME_PARAM_NAME = "keycloak.sessionIdMapperUpdater.infinispan.cacheName";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (KeycloakClusteredSsoDeploymentProcessor.isKeycloakSamlAuthMethod(deploymentUnit) && KeycloakClusteredSsoDeploymentProcessor.isDistributable(deploymentUnit)) {
            this.addSamlReplicationConfiguration(deploymentUnit, phaseContext);
        }
    }

    public static boolean isDistributable(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return false;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return false;
        }
        return webMetaData.getDistributable() != null || webMetaData.getReplicationConfig() != null;
    }

    public static boolean isKeycloakSamlAuthMethod(DeploymentUnit deploymentUnit) {
        if (Configuration.INSTANCE.getSecureDeployment(deploymentUnit) != null) {
            return true;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return false;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return false;
        }
        LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
        return loginConfig != null && Objects.equals(loginConfig.getAuthMethod(), "KEYCLOAK-SAML");
    }

    public void undeploy(DeploymentUnit du) {
    }

    private void addSamlReplicationConfiguration(DeploymentUnit deploymentUnit, DeploymentPhaseContext context) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        String cacheContainer = DEFAULT_CACHE_CONTAINER;
        String deploymentSessionCacheName = (deploymentUnit.getParent() == null ? "" : deploymentUnit.getParent().getName() + ".") + deploymentUnit.getName();
        if (webMetaData.getReplicationConfig() != null && webMetaData.getReplicationConfig().getCacheName() != null) {
            ServiceName sn = ServiceName.parse((String)webMetaData.getReplicationConfig().getCacheName());
            cacheContainer = sn.length() > 1 ? sn.getParent().getSimpleName() : sn.getSimpleName();
            deploymentSessionCacheName = sn.getSimpleName();
        }
        String ssoCacheName = deploymentSessionCacheName + ".ssoCache";
        ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        for (ParamValueMetaData contextParam : contextParams) {
            if (Objects.equals(contextParam.getParamName(), SSO_CACHE_CONTAINER_NAME_PARAM_NAME)) {
                cacheContainer = contextParam.getParamValue();
                continue;
            }
            if (!Objects.equals(contextParam.getParamName(), SSO_CACHE_NAME_PARAM_NAME)) continue;
            ssoCacheName = contextParam.getParamValue();
        }
        LOG.debugv("Determined SSO cache container configuration: container: {0}, cache: {1}", (Object)cacheContainer, (Object)ssoCacheName);
        this.addCacheDependency(context, deploymentUnit, cacheContainer, ssoCacheName);
        ParamValueMetaData paramContainer = new ParamValueMetaData();
        paramContainer.setParamName("org.keycloak.saml.replication.container");
        paramContainer.setParamValue(cacheContainer);
        contextParams.add(paramContainer);
        ParamValueMetaData paramSsoCache = new ParamValueMetaData();
        paramSsoCache.setParamName("org.keycloak.saml.replication.cache.sso");
        paramSsoCache.setParamValue(ssoCacheName);
        contextParams.add(paramSsoCache);
        webMetaData.setContextParams(contextParams);
    }

    private void addCacheDependency(DeploymentPhaseContext context, DeploymentUnit deploymentUnit, String cacheContainer, String cacheName) {
        ServiceName wf10CacheContainerServiceName = ServiceName.of((String[])new String[]{"jboss", "infinispan", cacheContainer});
        ServiceController wf10CacheContainerService = context.getServiceRegistry().getService(wf10CacheContainerServiceName);
        boolean legacy = wf10CacheContainerService != null;
        ServiceTarget st = context.getServiceTarget();
        if (legacy) {
            ServiceName cacheServiceName = wf10CacheContainerServiceName.append(new String[]{cacheName});
            ServiceController cacheService = context.getServiceRegistry().getService(cacheServiceName);
            if (cacheService != null) {
                st.addDependency(cacheServiceName);
            }
        } else {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            ServiceName cacheServiceName = support.getCapabilityServiceName("org.wildfly.clustering.infinispan.cache." + cacheContainer + "." + cacheName);
            ServiceController cacheService = context.getServiceRegistry().getService(cacheServiceName);
            if (cacheService != null) {
                st.addDependency(cacheServiceName);
            }
        }
    }
}

