/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class Configuration {
    static Configuration INSTANCE = new Configuration();
    private ModelNode config = new ModelNode();

    private Configuration() {
    }

    void updateModel(ModelNode operation, ModelNode model) {
        ModelNode node = this.config;
        ModelNode addr = operation.get("address");
        for (Property item : addr.asPropertyList()) {
            node = this.getNodeForAddressElement(node, item);
        }
        node.set(model);
    }

    private ModelNode getNodeForAddressElement(ModelNode node, Property item) {
        String key = item.getValue().asString();
        ModelNode keymodel = node.get(item.getName());
        return keymodel.get(key);
    }

    public ModelNode getSecureDeployment(DeploymentUnit deploymentUnit) {
        String name = this.preferredDeploymentName(deploymentUnit);
        ModelNode secureDeployment = this.config.get("subsystem").get("keycloak-saml").get("secure-deployment");
        if (secureDeployment.hasDefined(name)) {
            return secureDeployment.get(name);
        }
        return null;
    }

    private String preferredDeploymentName(DeploymentUnit deploymentUnit) {
        String deploymentName = deploymentUnit.getName();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return deploymentName;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            return deploymentName;
        }
        String moduleName = webMetaData.getModuleName();
        if (moduleName != null) {
            return moduleName + ".war";
        }
        return deploymentName;
    }
}

