/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.List;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.DoubleNumericFieldBridge;
import org.hibernate.search.bridge.builtin.FloatNumericFieldBridge;
import org.hibernate.search.bridge.builtin.IntegerNumericFieldBridge;
import org.hibernate.search.bridge.builtin.LongNumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;

public abstract class LucenePropertyHelper
implements PropertyHelper {
    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(value);
        }
        if (bridge instanceof IntegerNumericFieldBridge) {
            return Integer.parseInt(value);
        }
        if (bridge instanceof LongNumericFieldBridge) {
            return Long.parseLong(value);
        }
        if (bridge instanceof FloatNumericFieldBridge) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (bridge instanceof DoubleNumericFieldBridge) {
            return Double.parseDouble(value);
        }
        return value;
    }

    protected abstract FieldBridge getFieldBridge(String var1, List<String> var2);
}

