/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedKey;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSubjectProvider
implements SubjectProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultSubjectProvider.class);
    private String subjectNameQualifier = "http://cxf.apache.org/sts";
    private String subjectNameIDFormat;

    public void setSubjectNameQualifier(String subjectNameQualifier) {
        this.subjectNameQualifier = subjectNameQualifier;
        LOG.fine("Setting Subject Name Qualifier: " + subjectNameQualifier);
    }

    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
        LOG.fine("Setting Subject Name format: " + subjectNameIDFormat);
    }

    @Override
    public SubjectBean getSubject(TokenProviderParameters providerParameters, Document doc, byte[] secret) {
        TokenRequirements tokenRequirements = providerParameters.getTokenRequirements();
        KeyRequirements keyRequirements = providerParameters.getKeyRequirements();
        STSPropertiesMBean stsProperties = providerParameters.getStsProperties();
        String tokenType = tokenRequirements.getTokenType();
        String keyType = keyRequirements.getKeyType();
        String confirmationMethod = this.getSubjectConfirmationMethod(tokenType, keyType);
        Principal principal = null;
        ReceivedToken receivedToken = null;
        if (providerParameters.getTokenRequirements().getOnBehalfOf() != null) {
            receivedToken = providerParameters.getTokenRequirements().getOnBehalfOf();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else if (providerParameters.getTokenRequirements().getActAs() != null) {
            receivedToken = providerParameters.getTokenRequirements().getActAs();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else if (providerParameters.getTokenRequirements().getValidateTarget() != null) {
            receivedToken = providerParameters.getTokenRequirements().getValidateTarget();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else {
            principal = providerParameters.getPrincipal();
        }
        if (principal == null) {
            LOG.fine("Error in getting principal");
            throw new STSException("Error in getting principal", STSException.REQUEST_FAILED);
        }
        SubjectBean subjectBean = new SubjectBean(principal.getName(), this.subjectNameQualifier, confirmationMethod);
        LOG.fine("Creating new subject with principal name: " + principal.getName());
        if (this.subjectNameIDFormat != null && this.subjectNameIDFormat.length() > 0) {
            subjectBean.setSubjectNameIDFormat(this.subjectNameIDFormat);
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType)) {
            Crypto crypto = stsProperties.getEncryptionCrypto();
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            EncryptionProperties encryptionProperties = providerParameters.getEncryptionProperties();
            String encryptionName = encryptionProperties.getEncryptionName();
            if (encryptionName == null) {
                encryptionName = stsProperties.getEncryptionUsername();
            }
            if (encryptionName == null) {
                LOG.fine("No encryption Name is configured for Symmetric KeyType");
                throw new STSException("No Encryption Name is configured", STSException.REQUEST_FAILED);
            }
            cryptoType.setAlias(encryptionName);
            try {
                X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                if (certs == null || certs.length <= 0) {
                    new STSException("Encryption certificate is not found for alias: " + encryptionName, STSException.REQUEST_FAILED);
                }
                KeyInfoBean keyInfo = DefaultSubjectProvider.createKeyInfo(certs[0], secret, doc, encryptionProperties, crypto);
                subjectBean.setKeyInfo(keyInfo);
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException(ex.getMessage(), (Throwable)ex);
            }
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            ReceivedKey receivedKey = keyRequirements.getReceivedKey();
            if (stsProperties.isValidateUseKey() && stsProperties.getSignatureCrypto() != null) {
                if (receivedKey.getX509Cert() != null) {
                    try {
                        if (!stsProperties.getSignatureCrypto().verifyTrust(new X509Certificate[]{receivedKey.getX509Cert()}, false)) {
                            LOG.log(Level.FINE, "Error in trust validation of UseKey");
                            throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                        }
                    }
                    catch (WSSecurityException e) {
                        LOG.log(Level.FINE, "Error in trust validation of UseKey: ", e);
                        throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                    }
                }
                if (receivedKey.getPublicKey() != null) {
                    try {
                        if (!stsProperties.getSignatureCrypto().verifyTrust(receivedKey.getPublicKey())) {
                            LOG.log(Level.FINE, "Error in trust validation of UseKey");
                            throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                        }
                    }
                    catch (WSSecurityException e) {
                        LOG.log(Level.FINE, "Error in trust validation of UseKey: ", e);
                        throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                    }
                }
            }
            KeyInfoBean keyInfo = DefaultSubjectProvider.createKeyInfo(receivedKey.getX509Cert(), receivedKey.getPublicKey());
            subjectBean.setKeyInfo(keyInfo);
        }
        return subjectBean;
    }

    private String getSubjectConfirmationMethod(String tokenType, String keyType) {
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
                return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            }
            return "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            return "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        }
        return "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    }

    private static KeyInfoBean createKeyInfo(X509Certificate certificate, PublicKey publicKey) {
        KeyInfoBean keyInfo = new KeyInfoBean();
        if (certificate != null) {
            keyInfo.setCertificate(certificate);
            keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.X509_CERT);
        } else if (publicKey != null) {
            keyInfo.setPublicKey(publicKey);
            keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        }
        return keyInfo;
    }

    private static KeyInfoBean createKeyInfo(X509Certificate certificate, byte[] secret, Document doc, EncryptionProperties encryptionProperties, Crypto encryptionCrypto) throws WSSecurityException {
        KeyInfoBean keyInfo = new KeyInfoBean();
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        encrKey.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        encrKey.setEphemeralKey(secret);
        encrKey.setSymmetricEncAlgorithm(encryptionProperties.getEncryptionAlgorithm());
        encrKey.setUseThisCert(certificate);
        encrKey.setKeyEncAlgo(encryptionProperties.getKeyWrapAlgorithm());
        encrKey.prepare(doc, encryptionCrypto);
        Element encryptedKeyElement = encrKey.getEncryptedKeyElement();
        Element keyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        keyInfoElement.appendChild(encryptedKeyElement);
        keyInfo.setElement(keyInfoElement);
        return keyInfo;
    }
}

