/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.file.SingleFileStore;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractStoreConfiguration {
    private final String location;
    private final int maxEntries;

    public SingleFileStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties, String location, int maxEntries) {
        super(purgeOnStartup, fetchPersistentState, ignoreModifications, async, singletonStore, preload, shared, properties);
        this.location = location;
        this.maxEntries = maxEntries;
    }

    public String location() {
        return this.location;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SingleFileStoreConfiguration that = (SingleFileStoreConfiguration)o;
        if (this.maxEntries != that.maxEntries) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.maxEntries;
        return result;
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration{location='" + this.location + '\'' + ", maxEntries=" + this.maxEntries + '}';
    }
}

