/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;

public class SingleFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    private String location = "Infinispan-SingleFileStore";
    private int maxEntries = -1;

    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public SingleFileStoreConfigurationBuilder self() {
        return this;
    }

    public SingleFileStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public SingleFileStoreConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public SingleFileStoreConfiguration create() {
        return new SingleFileStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.location, this.maxEntries);
    }

    public Builder<?> read(SingleFileStoreConfiguration template) {
        this.location = template.location();
        this.maxEntries = template.maxEntries();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        this.preload = template.preload();
        this.shared = template.shared();
        return this;
    }
}

