/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.security.PublicKey;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.ClientConnection;
import org.keycloak.RSATokenVerifier;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.resources.Cors;

public class UserInfoEndpoint {
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse response;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final AppAuthManager appAuthManager;
    private final RealmModel realm;

    public UserInfoEndpoint(TokenManager tokenManager, RealmModel realm) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.appAuthManager = new AppAuthManager();
    }

    @Path(value="/")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response issueUserInfoPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response issueUserInfoGet(@Context HttpHeaders headers) {
        String accessToken = this.appAuthManager.extractAuthorizationHeaderToken(headers);
        return this.issueUserInfo(accessToken);
    }

    @Path(value="/")
    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response issueUserInfoPost(@FormParam(value="access_token") String accessToken) {
        return this.issueUserInfo(accessToken);
    }

    private Response issueUserInfo(String tokenString) {
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection).event(EventType.USER_INFO_REQUEST).detail("auth_method", "validate_access_token");
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.realm.getPublicKey(), (String)Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        }
        catch (Exception e) {
            throw new ErrorResponseException("invalid_grant", "Token invalid", Response.Status.FORBIDDEN);
        }
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, token.getSessionState());
        ClientSessionModel clientSession = this.session.sessions().getClientSession(token.getClientSession());
        ClientModel clientModel = this.realm.getClientByClientId(token.getIssuedFor());
        UserModel userModel = userSession.getUser();
        AccessToken userInfo = new AccessToken();
        this.tokenManager.transformAccessToken(this.session, userInfo, this.realm, clientModel, userModel, userSession, clientSession);
        event.detail("username", userModel.getUsername()).client(clientModel).session(userSession).user(userModel).success();
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.putAll(userInfo.getOtherClaims());
        claims.put("sub", userModel.getId());
        return Cors.add(this.request, Response.ok(claims)).auth().allowedOrigins(token).build();
    }
}

