/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.store.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.idm.model.Attribute;
import org.keycloak.federation.ldap.idm.model.AttributedType;
import org.keycloak.federation.ldap.idm.model.IdentityType;
import org.keycloak.federation.ldap.idm.model.LDAPUser;
import org.keycloak.federation.ldap.idm.query.AttributeParameter;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.IdentityQuery;
import org.keycloak.federation.ldap.idm.query.IdentityQueryBuilder;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.BetweenCondition;
import org.keycloak.federation.ldap.idm.query.internal.DefaultQueryBuilder;
import org.keycloak.federation.ldap.idm.query.internal.EqualCondition;
import org.keycloak.federation.ldap.idm.query.internal.GreaterThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.InCondition;
import org.keycloak.federation.ldap.idm.query.internal.LessThanCondition;
import org.keycloak.federation.ldap.idm.query.internal.LikeCondition;
import org.keycloak.federation.ldap.idm.store.IdentityStore;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStoreConfiguration;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPMappingConfiguration;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPOperationManager;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPUtil;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.reflection.NamedPropertyCriteria;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;
import org.keycloak.models.utils.reflection.PropertyQueries;
import org.keycloak.models.utils.reflection.TypedPropertyCriteria;
import org.keycloak.util.reflections.Reflections;

public class LDAPIdentityStore
implements IdentityStore {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStore.class);
    public static final String EMPTY_ATTRIBUTE_VALUE = " ";
    private final LDAPIdentityStoreConfiguration config;
    private final LDAPOperationManager operationManager;

    public LDAPIdentityStore(LDAPIdentityStoreConfiguration config) {
        this.config = config;
        try {
            this.operationManager = new LDAPOperationManager(this.getConfig());
        }
        catch (NamingException e) {
            throw new ModelException("Couldn't init operation manager", (Throwable)e);
        }
    }

    @Override
    public LDAPIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void add(AttributedType attributedType) {
        attributedType.setId(null);
        String entryDN = this.getBindingDN(attributedType, true);
        this.operationManager.createSubContext(entryDN, this.extractAttributes(attributedType, true));
        this.addToParentAsMember(attributedType);
        attributedType.setId(this.getEntryIdentifier(attributedType));
        attributedType.setEntryDN(entryDN);
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] successfully added to identity store [%s].", (Object)attributedType.getId(), (Object)this);
        }
    }

    @Override
    public void update(AttributedType attributedType) {
        BasicAttributes updatedAttributes = this.extractAttributes(attributedType, false);
        NamingEnumeration<javax.naming.directory.Attribute> attributes = updatedAttributes.getAll();
        this.operationManager.modifyAttributes(this.getBindingDN(attributedType, true), attributes);
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] successfully updated to identity store [%s].", (Object)attributedType.getId(), (Object)this);
        }
    }

    @Override
    public void remove(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        this.operationManager.removeEntryById(this.getBaseDN(attributedType), attributedType.getId(), mappingConfig);
        if (logger.isTraceEnabled()) {
            logger.tracef("Type with identifier [%s] successfully removed from identity store [%s].", (Object)attributedType.getId(), (Object)this);
        }
    }

    @Override
    public <V extends IdentityType> List<V> fetchQueryResults(IdentityQuery<V> identityQuery) {
        ArrayList<IdentityType> results = new ArrayList<IdentityType>();
        try {
            if (identityQuery.getSorting() != null && !identityQuery.getSorting().isEmpty()) {
                throw new ModelException("LDAP Identity Store does not support sorted queries.");
            }
            for (Condition condition : identityQuery.getConditions()) {
                if (!IdentityType.ID.equals(condition.getParameter())) continue;
                if (EqualCondition.class.isInstance(condition)) {
                    EqualCondition equalCondition = (EqualCondition)condition;
                    SearchResult search = this.operationManager.lookupById(this.getConfig().getBaseDN(), equalCondition.getValue().toString(), null);
                    if (search != null) {
                        results.add((IdentityType)this.populateAttributedType(search, null));
                    }
                }
                return results;
            }
            if (!IdentityType.class.equals(identityQuery.getIdentityType())) {
                LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(identityQuery.getIdentityType());
                StringBuilder filter = this.createIdentityTypeSearchFilter(identityQuery, ldapEntryConfig);
                String baseDN = this.getBaseDN(ldapEntryConfig);
                List<SearchResult> search = this.getConfig().isPagination() && identityQuery.getLimit() > 0 ? this.operationManager.searchPaginated(baseDN, filter.toString(), ldapEntryConfig, identityQuery) : this.operationManager.search(baseDN, filter.toString(), ldapEntryConfig);
                for (SearchResult result : search) {
                    if (result.getNameInNamespace().equals(baseDN)) continue;
                    results.add((IdentityType)this.populateAttributedType(result, null));
                }
            }
        }
        catch (Exception e) {
            throw new ModelException("Querying of identity type failed " + identityQuery, (Throwable)e);
        }
        return results;
    }

    @Override
    public <V extends IdentityType> int countQueryResults(IdentityQuery<V> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public IdentityQueryBuilder createQueryBuilder() {
        return new DefaultQueryBuilder(this);
    }

    @Override
    public boolean validatePassword(LDAPUser user, String password) {
        String userDN = this.getEntryDNOfUser(user);
        if (logger.isDebugEnabled()) {
            logger.debugf("Using DN [%s] for authentication of user [%s]", (Object)userDN, (Object)user.getLoginName());
        }
        return this.operationManager.authenticate(userDN, password);
    }

    @Override
    public void updatePassword(LDAPUser user, String password) {
        String userDN = this.getEntryDNOfUser(user);
        if (logger.isDebugEnabled()) {
            logger.debugf("Using DN [%s] for updating LDAP password of user [%s]", (Object)userDN, (Object)user.getLoginName());
        }
        if (this.getConfig().isActiveDirectory()) {
            this.updateADPassword(userDN, password);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute("userpassword", password);
                mods[0] = new ModificationItem(2, mod0);
                this.operationManager.modifyAttribute(userDN, mod0);
            }
            catch (Exception e) {
                throw new ModelException("Error updating password.", (Throwable)e);
            }
        }
    }

    private void updateADPassword(String userDN, String password) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
            modItems.add(new ModificationItem(2, unicodePwd));
            if (this.getConfig().isUserAccountControlsAfterPasswordUpdate()) {
                BasicAttribute userAccountControl = new BasicAttribute("userAccountControl", "512");
                modItems.add(new ModificationItem(2, userAccountControl));
                logger.debugf("Attribute userAccountControls will be switched to 512 after password update of user [%s]", (Object)userDN);
            }
            this.operationManager.modifyAttributes(userDN, modItems.toArray(new ModificationItem[0]));
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e);
        }
    }

    private String getEntryDNOfUser(LDAPUser user) {
        String entryDN = user.getEntryDN();
        if (entryDN != null) {
            return entryDN;
        }
        String username = user.getLoginName();
        if ((user = this.getUser(username)) == null) {
            throw new ModelException("No LDAP user found with username " + username);
        }
        return user.getEntryDN();
    }

    public LDAPUser getUser(String username) {
        if (LDAPIdentityStore.isNullOrEmpty(username)) {
            return null;
        }
        IdentityQueryBuilder queryBuilder = this.createQueryBuilder();
        List<LDAPUser> agents = queryBuilder.createIdentityQuery(LDAPUser.class).where(queryBuilder.equal(LDAPUser.LOGIN_NAME, username)).getResultList();
        if (agents.isEmpty()) {
            return null;
        }
        if (agents.size() == 1) {
            return agents.get(0);
        }
        throw new ModelDuplicateException("Error - multiple Agent objects found with same login name");
    }

    private String getBaseDN(LDAPMappingConfiguration ldapEntryConfig) {
        String baseDN = this.getConfig().getBaseDN();
        if (ldapEntryConfig.getBaseDN() != null) {
            baseDN = ldapEntryConfig.getBaseDN();
        }
        return baseDN;
    }

    protected <V extends IdentityType> StringBuilder createIdentityTypeSearchFilter(IdentityQuery<V> identityQuery, LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder filter = new StringBuilder();
        for (Condition condition : identityQuery.getConditions()) {
            Object parameterValue;
            QueryParameter queryParameter = condition.getParameter();
            if (IdentityType.ID.equals(queryParameter) || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            String attributeName = ldapEntryConfig.getMappedProperties().get(attributeParameter.getName());
            if (attributeName == null) continue;
            if (EqualCondition.class.isInstance(condition)) {
                EqualCondition equalCondition = (EqualCondition)condition;
                parameterValue = equalCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                filter.append("(").append(attributeName).append("=").append(parameterValue).append(")");
                continue;
            }
            if (LikeCondition.class.isInstance(condition)) {
                LikeCondition likeCondition = (LikeCondition)condition;
                parameterValue = (String)likeCondition.getValue();
                continue;
            }
            if (GreaterThanCondition.class.isInstance(condition)) {
                GreaterThanCondition greaterThanCondition = (GreaterThanCondition)condition;
                parameterValue = greaterThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (greaterThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append(">=").append(parameterValue).append(")");
                    continue;
                }
                filter.append("(").append(attributeName).append(">").append(parameterValue).append(")");
                continue;
            }
            if (LessThanCondition.class.isInstance(condition)) {
                LessThanCondition lessThanCondition = (LessThanCondition)condition;
                parameterValue = lessThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (lessThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append("<=").append(parameterValue).append(")");
                    continue;
                }
                filter.append("(").append(attributeName).append("<").append(parameterValue).append(")");
                continue;
            }
            if (BetweenCondition.class.isInstance(condition)) {
                BetweenCondition betweenCondition = (BetweenCondition)condition;
                Object x = betweenCondition.getX();
                Object y = betweenCondition.getY();
                if (Date.class.isInstance(x)) {
                    x = LDAPUtil.formatDate((Date)x);
                }
                if (Date.class.isInstance(y)) {
                    y = LDAPUtil.formatDate((Date)y);
                }
                filter.append("(").append(x).append("<=").append(attributeName).append("<=").append(y).append(")");
                continue;
            }
            if (InCondition.class.isInstance(condition)) {
                InCondition inCondition = (InCondition)condition;
                Object[] valuesToCompare = inCondition.getValue();
                filter.append("(&(");
                for (int i = 0; i < valuesToCompare.length; ++i) {
                    Object value = valuesToCompare[i];
                    filter.append("(").append(attributeName).append("=").append(value).append(")");
                }
                filter.append("))");
                continue;
            }
            throw new ModelException("Unsupported query condition [" + condition + "].");
        }
        filter.insert(0, "(&(");
        filter.append((CharSequence)this.getObjectClassesFilter(ldapEntryConfig));
        filter.append("))");
        return filter;
    }

    private StringBuilder getObjectClassesFilter(LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder builder = new StringBuilder();
        if (ldapEntryConfig != null && !ldapEntryConfig.getObjectClasses().isEmpty()) {
            for (String objectClass : ldapEntryConfig.getObjectClasses()) {
                builder.append("(").append("objectclass").append("=").append(objectClass).append(")");
            }
        } else {
            builder.append("(").append("objectclass").append("=").append("*").append(")");
        }
        return builder;
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType) {
        return this.populateAttributedType(searchResult, attributedType, 0);
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType, int hierarchyDepthCount) {
        try {
            String entryDN = searchResult.getNameInNamespace();
            Attributes attributes = searchResult.getAttributes();
            if (attributedType == null) {
                attributedType = (AttributedType)Reflections.newInstance(this.getConfig().getSupportedTypeByBaseDN(entryDN, this.getEntryObjectClasses(attributes)));
            }
            attributedType.setEntryDN(entryDN);
            LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
            if (hierarchyDepthCount > mappingConfig.getHierarchySearchDepth()) {
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Populating attributed type [%s] from DN [%s]", (Object)attributedType, (Object)entryDN);
            }
            NamingEnumeration<? extends javax.naming.directory.Attribute> ldapAttributes = attributes.getAll();
            while (ldapAttributes.hasMore()) {
                Object attributeValue;
                javax.naming.directory.Attribute ldapAttribute = ldapAttributes.next();
                try {
                    attributeValue = ldapAttribute.get();
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                String ldapAttributeName = ldapAttribute.getID();
                if (ldapAttributeName.toLowerCase().equals(this.getConfig().getUniqueIdentifierAttributeName().toLowerCase())) {
                    attributedType.setId(this.operationManager.decodeEntryUUID(attributeValue));
                    continue;
                }
                String attributeName = this.findAttributeName(mappingConfig.getMappedProperties(), ldapAttributeName);
                if (attributeName == null) continue;
                Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{attributeName})).getFirstResult();
                if (property != null) {
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Populating property [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{property.getName(), ldapAttributeName, attributeValue, entryDN});
                    }
                    if (property.getJavaClass().equals(Date.class)) {
                        property.setValue((Object)attributedType, (Object)LDAPUtil.parseDate(attributeValue.toString()));
                        continue;
                    }
                    property.setValue((Object)attributedType, attributeValue);
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.tracef("Populating attribute [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{attributeName, ldapAttributeName, attributeValue, entryDN});
                }
                attributedType.setAttribute(new Attribute<Serializable>(attributeName, (Serializable)attributeValue));
            }
            if (IdentityType.class.isInstance(attributedType)) {
                IdentityType identityType = (IdentityType)attributedType;
                String createdTimestamp = attributes.get("createTimeStamp").get().toString();
                identityType.setCreatedDate(LDAPUtil.parseDate(createdTimestamp));
            }
            LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
            if (mappingConfig.getParentMembershipAttributeName() != null) {
                List<SearchResult> search;
                StringBuilder filter = new StringBuilder("(&");
                String entryBaseDN = entryDN.substring(entryDN.indexOf(",") + 1);
                filter.append("(").append((CharSequence)this.getObjectClassesFilter(entryConfig)).append(")").append("(").append(mappingConfig.getParentMembershipAttributeName()).append("=").append("").append(this.getBindingDN(attributedType, false)).append(",").append(entryBaseDN).append(")");
                filter.append(")");
                if (logger.isTraceEnabled()) {
                    logger.tracef("Searching parent entry for DN [%s] using filter [%s].", (Object)entryBaseDN, (Object)filter.toString());
                }
                if (!(search = this.operationManager.search(this.getConfig().getBaseDN(), filter.toString(), entryConfig)).isEmpty()) {
                    SearchResult next = search.get(0);
                    Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
                    if (parentProperty != null) {
                        String parentDN = next.getNameInNamespace();
                        String parentBaseDN = parentDN.substring(parentDN.indexOf(",") + 1);
                        Class<? extends AttributedType> baseDNType = this.getConfig().getSupportedTypeByBaseDN(parentBaseDN, this.getEntryObjectClasses(attributes));
                        if (parentProperty.getJavaClass().isAssignableFrom(baseDNType)) {
                            if (logger.isTraceEnabled()) {
                                logger.tracef("Found parent [%s] for entry for DN [%s].", (Object)parentDN, (Object)entryDN);
                            }
                            int hierarchyDepthCount1 = ++hierarchyDepthCount;
                            parentProperty.setValue((Object)attributedType, (Object)this.populateAttributedType(next, null, hierarchyDepthCount1));
                        }
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.tracef("No parent entry found for DN [%s] using filter [%s].", (Object)entryDN, (Object)filter.toString());
                }
            }
        }
        catch (Exception e) {
            throw new ModelException("Could not populate attribute type " + attributedType + ".", (Throwable)e);
        }
        return attributedType;
    }

    private String findAttributeName(Map<String, String> attrMapping, String ldapAttributeName) {
        for (Map.Entry<String, String> currentAttr : attrMapping.entrySet()) {
            if (!currentAttr.getValue().equalsIgnoreCase(ldapAttributeName)) continue;
            return currentAttr.getKey();
        }
        return null;
    }

    private List<String> getEntryObjectClasses(Attributes attributes) throws NamingException {
        javax.naming.directory.Attribute objectClassesAttribute = attributes.get("objectclass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        if (objectClassesAttribute == null) {
            return objectClasses;
        }
        NamingEnumeration<?> all = objectClassesAttribute.getAll();
        while (all.hasMore()) {
            objectClasses.add(all.next().toString());
        }
        return objectClasses;
    }

    protected BasicAttributes extractAttributes(AttributedType attributedType, boolean isCreate) {
        BasicAttributes entryAttributes = new BasicAttributes();
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Map<String, String> mappedProperties = mappingConfig.getMappedProperties();
        for (String propertyName : mappedProperties.keySet()) {
            if (mappingConfig.getReadOnlyAttributes().contains(propertyName) || !isCreate && mappingConfig.getBindingProperty().getName().equals(propertyName)) continue;
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName})).getFirstResult();
            Object propertyValue = null;
            if (property != null) {
                propertyValue = property.getValue((Object)attributedType);
            } else {
                Attribute attribute = attributedType.getAttribute(propertyName);
                if (attribute != null) {
                    propertyValue = attribute.getValue();
                }
            }
            if (AttributedType.class.isInstance(propertyValue)) {
                AttributedType referencedType = (AttributedType)propertyValue;
                propertyValue = this.getBindingDN(referencedType, true);
            } else if (propertyValue == null || LDAPIdentityStore.isNullOrEmpty(propertyValue.toString())) {
                propertyValue = EMPTY_ATTRIBUTE_VALUE;
            }
            entryAttributes.put(mappedProperties.get(propertyName), propertyValue);
        }
        if (isCreate) {
            LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(attributedType.getClass());
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            for (String objectClassValue : ldapEntryConfig.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
                if (!objectClassValue.equals("groupOfNames") && !objectClassValue.equals("groupOfEntries") && !objectClassValue.equals("groupOfUniqueNames")) continue;
                entryAttributes.put("member", EMPTY_ATTRIBUTE_VALUE);
            }
            entryAttributes.put(objectClassAttribute);
        }
        return entryAttributes;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getConfig().getMappingConfig(attributedType);
        if (mappingConfig == null) {
            throw new ModelException("Not mapped type [" + attributedType + "].");
        }
        return mappingConfig;
    }

    public String getBindingDN(AttributedType attributedType, boolean appendBaseDN) {
        String dn;
        String bindingAttribute;
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property<String> idProperty = mappingConfig.getIdProperty();
        String baseDN = mappingConfig.getBaseDN() == null || !appendBaseDN ? "" : "," + this.getBaseDN(attributedType);
        Property<String> bindingProperty = mappingConfig.getBindingProperty();
        if (bindingProperty == null) {
            bindingAttribute = mappingConfig.getMappedProperties().get(idProperty.getName());
            dn = (String)idProperty.getValue((Object)attributedType);
        } else {
            bindingAttribute = mappingConfig.getMappedProperties().get(bindingProperty.getName());
            dn = (String)mappingConfig.getBindingProperty().getValue((Object)attributedType);
        }
        return bindingAttribute + "=" + dn + baseDN;
    }

    private String getBaseDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        String baseDN = mappingConfig.getBaseDN();
        String parentDN = mappingConfig.getParentMapping().get(mappingConfig.getIdProperty().getValue((Object)attributedType));
        if (parentDN != null) {
            baseDN = parentDN;
        } else {
            AttributedType parentType;
            Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
            if (parentProperty != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
                Property<String> parentIdProperty = this.getMappingConfig(parentType.getClass()).getIdProperty();
                String parentId = (String)parentIdProperty.getValue((Object)parentType);
                String parentBaseDN = mappingConfig.getParentMapping().get(parentId);
                baseDN = parentBaseDN != null ? parentBaseDN : this.getBaseDN(parentType);
            }
        }
        if (baseDN == null) {
            baseDN = this.getConfig().getBaseDN();
        }
        return baseDN;
    }

    protected void addToParentAsMember(AttributedType attributedType) {
        AttributedType parentType;
        Property parentProperty;
        LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
        if (entryConfig.getParentMembershipAttributeName() != null && (parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult()) != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
            Attributes attributes = this.operationManager.getAttributes(parentType.getId(), this.getBaseDN(parentType), entryConfig);
            javax.naming.directory.Attribute attribute = attributes.get(entryConfig.getParentMembershipAttributeName());
            attribute.add(this.getBindingDN(attributedType, true));
            this.operationManager.modifyAttribute(this.getBindingDN(parentType, true), attribute);
        }
    }

    protected String getEntryIdentifier(AttributedType attributedType) {
        try {
            List<SearchResult> search = this.operationManager.search(this.getBaseDN(attributedType), "(" + this.getBindingDN(attributedType, false) + ")", this.getMappingConfig(attributedType.getClass()));
            javax.naming.directory.Attribute id = search.get(0).getAttributes().get(this.getConfig().getUniqueIdentifierAttributeName());
            if (id == null) {
                throw new ModelException("Could not retrieve identifier for entry [" + this.getBindingDN(attributedType, true) + "].");
            }
            return this.operationManager.decodeEntryUUID(id.get());
        }
        catch (NamingException ne) {
            throw new ModelException("Could not add type [" + attributedType + "].", (Throwable)ne);
        }
    }
}

