/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.store.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.idm.model.IdentityType;
import org.keycloak.federation.ldap.idm.query.IdentityQuery;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStoreConfiguration;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPMappingConfiguration;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPUtil;
import org.keycloak.models.ModelException;

public class LDAPOperationManager {
    private static final Logger logger = Logger.getLogger(LDAPOperationManager.class);
    private final LDAPIdentityStoreConfiguration config;
    private final Map<String, Object> connectionProperties;

    public LDAPOperationManager(LDAPIdentityStoreConfiguration config) throws NamingException {
        this.config = config;
        this.connectionProperties = Collections.unmodifiableMap(this.createConnectionProperties());
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void modifyAttributes(String dn, NamingEnumeration<Attribute> attributes) {
        try {
            ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
            while (attributes.hasMore()) {
                ModificationItem modItem = new ModificationItem(2, attributes.next());
                modItems.add(modItem);
            }
            this.modifyAttributes(dn, modItems.toArray(new ModificationItem[0]));
        }
        catch (NamingException ne) {
            throw new ModelException("Could not modify attributes on entry from DN [" + dn + "]", (Throwable)ne);
        }
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeEntryById(final String baseDN, String id, LDAPMappingConfiguration mappingConfiguration) {
        final String filter = this.getFilterById(baseDN, id);
        try {
            final SearchControls cons = this.getSearchControls(mappingConfiguration);
            this.execute(new LdapOperation<SearchResult>(){

                @Override
                public SearchResult execute(LdapContext context) throws NamingException {
                    NamingEnumeration<SearchResult> result = context.search(baseDN, filter, cons);
                    if (result.hasMore()) {
                        SearchResult sr = result.next();
                        if (logger.isDebugEnabled()) {
                            logger.debugf("Removing entry [%s] with attributes: [", (Object)sr.getNameInNamespace());
                            NamingEnumeration<? extends Attribute> all = sr.getAttributes().getAll();
                            while (all.hasMore()) {
                                Attribute attribute = all.next();
                                logger.debugf("  %s = %s", (Object)attribute.getID(), attribute.get());
                            }
                            logger.debugf("]", new Object[0]);
                        }
                        LDAPOperationManager.this.destroySubcontext(context, sr.getNameInNamespace());
                    }
                    result.close();
                    return null;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not remove entry from DN [" + baseDN + "] and id [" + id + "]", (Throwable)e);
        }
    }

    public List<SearchResult> search(final String baseDN, final String filter, LDAPMappingConfiguration mappingConfiguration) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = this.getSearchControls(mappingConfiguration);
        try {
            return this.execute(new LdapOperation<List<SearchResult>>(){

                @Override
                public List<SearchResult> execute(LdapContext context) throws NamingException {
                    NamingEnumeration<SearchResult> search = context.search(baseDN, filter, cons);
                    while (search.hasMoreElements()) {
                        result.add(search.nextElement());
                    }
                    search.close();
                    return result;
                }
            });
        }
        catch (NamingException e) {
            logger.errorf((Throwable)e, "Could not query server using DN [%s] and filter [%s]", (Object)baseDN, (Object)filter);
            throw e;
        }
    }

    public <V extends IdentityType> List<SearchResult> searchPaginated(final String baseDN, final String filter, LDAPMappingConfiguration mappingConfiguration, final IdentityQuery<V> identityQuery) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = this.getSearchControls(mappingConfiguration);
        try {
            return this.execute(new LdapOperation<List<SearchResult>>(){

                @Override
                public List<SearchResult> execute(LdapContext context) throws NamingException {
                    try {
                        byte[] cookie = (byte[])identityQuery.getPaginationContext();
                        PagedResultsControl pagedControls = new PagedResultsControl(identityQuery.getLimit(), cookie, true);
                        context.setRequestControls(new Control[]{pagedControls});
                        NamingEnumeration<SearchResult> search = context.search(baseDN, filter, cons);
                        while (search.hasMoreElements()) {
                            result.add(search.nextElement());
                        }
                        search.close();
                        Control[] responseControls = context.getResponseControls();
                        if (responseControls != null) {
                            for (Control respControl : responseControls) {
                                if (!(respControl instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)respControl;
                                cookie = prrc.getCookie();
                                identityQuery.setPaginationContext(cookie);
                            }
                        }
                        return result;
                    }
                    catch (IOException ioe) {
                        logger.errorf((Throwable)ioe, "Could not query server with paginated query using DN [%s], filter [%s]", (Object)baseDN, (Object)filter);
                        throw new NamingException(ioe.getMessage());
                    }
                }
            });
        }
        catch (NamingException e) {
            logger.errorf((Throwable)e, "Could not query server using DN [%s] and filter [%s]", (Object)baseDN, (Object)filter);
            throw e;
        }
    }

    private SearchControls getSearchControls(LDAPMappingConfiguration mappingConfiguration) {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        cons.setReturningObjFlag(false);
        List<String> returningAttributes = this.getReturningAttributes(mappingConfiguration);
        cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        return cons;
    }

    public String getFilterById(String baseDN, String id) {
        String filter = null;
        if (this.config.isActiveDirectory()) {
            final String strObjectGUID = "<GUID=" + id + ">";
            try {
                Attributes attributes = this.execute(new LdapOperation<Attributes>(){

                    @Override
                    public Attributes execute(LdapContext context) throws NamingException {
                        return context.getAttributes(strObjectGUID);
                    }
                });
                byte[] objectGUID = (byte[])attributes.get("objectGUID").get();
                filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + LDAPUtil.convertObjectGUIToByteString(objectGUID) + "))";
            }
            catch (NamingException ne) {
                return filter;
            }
        }
        if (filter == null) {
            filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + id + "))";
        }
        return filter;
    }

    public SearchResult lookupById(final String baseDN, String id, LDAPMappingConfiguration mappingConfiguration) {
        final String filter = this.getFilterById(baseDN, id);
        try {
            final SearchControls cons = this.getSearchControls(mappingConfiguration);
            return this.execute(new LdapOperation<SearchResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SearchResult execute(LdapContext context) throws NamingException {
                    try (NamingEnumeration<SearchResult> search = context.search(baseDN, filter, cons);){
                        if (search.hasMoreElements()) {
                            SearchResult searchResult = search.next();
                            return searchResult;
                        }
                    }
                    return null;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not query server using DN [" + baseDN + "] and filter [" + filter + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySubcontext(LdapContext context, String dn) {
        try {
            NamingEnumeration<Binding> enumeration = null;
            try {
                enumeration = context.listBindings(dn);
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    String name = binding.getNameInNamespace();
                    this.destroySubcontext(context, name);
                }
                context.unbind(dn);
            }
            finally {
                try {
                    enumeration.close();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            throw new ModelException("Could not unbind DN [" + dn + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String dn, String password) {
        InitialContext authCtx = null;
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>(this.connectionProperties);
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", password);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            authCtx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)e, "Authentication failed for DN [%s]", (Object)dn);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    public void modifyAttributes(final String dn, final ModificationItem[] mods) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debugf("Modifying attributes for entry [%s]: [", (Object)dn);
                for (ModificationItem item : mods) {
                    Object values = item.getAttribute().size() > 0 ? item.getAttribute().get() : "No values";
                    logger.debugf("  Op [%s]: %s = %s", (Object)item.getModificationOp(), (Object)item.getAttribute().getID(), values);
                }
                logger.debugf("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    context.modifyAttributes(dn, mods);
                    return null;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not modify attribute for DN [" + dn + "]", (Throwable)e);
        }
    }

    public void createSubContext(final String name, final Attributes attributes) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debugf("Creating entry [%s] with attributes: [", (Object)name);
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute attribute = all.next();
                    logger.debugf("  %s = %s", (Object)attribute.getID(), attribute.get());
                }
                logger.debugf("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    DirContext subcontext = context.createSubcontext(name, attributes);
                    subcontext.close();
                    return null;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Error creating subcontext [" + name + "]", (Throwable)e);
        }
    }

    private String getUniqueIdentifierAttributeName() {
        return this.config.getUniqueIdentifierAttributeName();
    }

    private NamingEnumeration<SearchResult> createEmptyEnumeration() {
        return new NamingEnumeration<SearchResult>(){

            @Override
            public SearchResult next() throws NamingException {
                return null;
            }

            @Override
            public boolean hasMore() throws NamingException {
                return false;
            }

            @Override
            public void close() throws NamingException {
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public SearchResult nextElement() {
                return null;
            }
        };
    }

    public Attributes getAttributes(String entryUUID, String baseDN, LDAPMappingConfiguration mappingConfiguration) {
        SearchResult search = this.lookupById(baseDN, entryUUID, mappingConfiguration);
        if (search == null) {
            throw new ModelException("Couldn't find item with entryUUID [" + entryUUID + "] and baseDN [" + baseDN + "]");
        }
        return search.getAttributes();
    }

    public String decodeEntryUUID(Object entryUUID) {
        String id = this.config.isActiveDirectory() ? LDAPUtil.decodeObjectGUID((byte[])entryUUID) : entryUUID.toString();
        return id;
    }

    private LdapContext createLdapContext() throws NamingException {
        return new InitialLdapContext(new Hashtable<String, Object>(this.connectionProperties), null);
    }

    private Map<String, Object> createConnectionProperties() {
        String url;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("java.naming.factory.initial", this.config.getFactoryName());
        env.put("java.naming.security.authentication", this.config.getAuthType());
        String protocol = this.config.getProtocol();
        if (protocol != null) {
            env.put("java.naming.security.protocol", protocol);
        }
        String bindDN = this.config.getBindDN();
        char[] bindCredential = null;
        if (this.config.getBindCredential() != null) {
            bindCredential = this.config.getBindCredential().toCharArray();
        }
        if (bindDN != null) {
            env.put("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindCredential);
        }
        if ((url = this.config.getLdapURL()) == null) {
            throw new RuntimeException("url");
        }
        env.put("java.naming.provider.url", url);
        Properties additionalProperties = this.config.getConnectionProperties();
        if (additionalProperties != null) {
            for (Object key : additionalProperties.keySet()) {
                env.put(key.toString(), additionalProperties.getProperty(key.toString()));
            }
        }
        if (this.config.isActiveDirectory()) {
            env.put("java.naming.ldap.attributes.binary", "objectGUID");
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Creating LdapContext using properties: [%s]", env);
        }
        return env;
    }

    private <R> R execute(LdapOperation<R> operation) throws NamingException {
        LdapContext context = null;
        try {
            context = this.createLdapContext();
            R r = operation.execute(context);
            return r;
        }
        catch (NamingException ne) {
            logger.error((Object)"Could not create Ldap context or operation execution error.", (Throwable)ne);
            throw ne;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {
                    logger.error((Object)"Could not close Ldap context.", (Throwable)ne);
                }
            }
        }
    }

    private List<String> getReturningAttributes(LDAPMappingConfiguration mappingConfiguration) {
        ArrayList<String> returningAttributes = new ArrayList<String>();
        if (mappingConfiguration != null) {
            returningAttributes.addAll(mappingConfiguration.getMappedProperties().values());
            returningAttributes.add(mappingConfiguration.getParentMembershipAttributeName());
        } else {
            returningAttributes.add("*");
        }
        returningAttributes.add(this.getUniqueIdentifierAttributeName());
        returningAttributes.add("createTimeStamp");
        returningAttributes.add("objectclass");
        return returningAttributes;
    }

    private static interface LdapOperation<R> {
        public R execute(LdapContext var1) throws NamingException;
    }
}

