/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.resource.AdministeredObjectDefinition;
import javax.resource.AdministeredObjectDefinitions;
import org.jboss.as.connector.deployers.ra.DirectAdministeredObjectInjectionSource;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class AdministeredObjectDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName ADMINISTERED_OBJECT_DEFINITION = DotName.createSimple((String)AdministeredObjectDefinition.class.getName());
    private static final DotName ADMINISTERED_OBJECT_DEFINITIONS = DotName.createSimple((String)AdministeredObjectDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List adminObjects;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List adminObjectDefinitions = index.getAnnotations(ADMINISTERED_OBJECT_DEFINITIONS);
        if (adminObjectDefinitions != null) {
            for (AnnotationInstance annotation : adminObjectDefinitions) {
                AnnotationTarget target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeMessages.MESSAGES.classOnlyAnnotation("@AdministeredObjectDefinitions", target);
                }
                List<AnnotationInstance> adminObjects2 = this.getNestedAdministeredObjectAnnotations(annotation);
                for (AnnotationInstance adminObject : adminObjects2) {
                    this.processAdministeredObjectDefinition(eeModuleDescription, adminObject, (ClassInfo)target, applicationClasses);
                }
            }
        }
        if ((adminObjects = index.getAnnotations(ADMINISTERED_OBJECT_DEFINITION)) != null) {
            for (AnnotationInstance adminObject : adminObjects) {
                AnnotationTarget target = adminObject.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeMessages.MESSAGES.classOnlyAnnotation("@AdministeredObjectDefinition", target);
                }
                this.processAdministeredObjectDefinition(eeModuleDescription, adminObject, (ClassInfo)target, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processAdministeredObjectDefinition(EEModuleDescription eeModuleDescription, AnnotationInstance adminObjectDefinition, ClassInfo targetClass, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        BindingConfiguration bindingConfiguration = this.getBindingConfiguration(adminObjectDefinition);
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(targetClass.name().toString());
        classDescription.getBindingConfigurations().add(bindingConfiguration);
    }

    private BindingConfiguration getBindingConfiguration(AnnotationInstance adminObjectAnnotation) {
        String clz;
        String name = this.asString(adminObjectAnnotation, "name");
        if (name == null || name.isEmpty()) {
            throw EeMessages.MESSAGES.annotationAttributeMissing("@AdministeredObjectDefinition", "name");
        }
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        if ((clz = this.asString(adminObjectAnnotation, "className")) == null || clz.equals(Object.class.getName())) {
            throw EeMessages.MESSAGES.annotationAttributeMissing("@AdministeredObjectDefinition", "className");
        }
        String ra = this.asString(adminObjectAnnotation, "resourceAdapter");
        if (ra == null || ra.equals(Object.class.getName())) {
            throw EeMessages.MESSAGES.annotationAttributeMissing("@AdministeredObjectDefinition", "resourceAdapter");
        }
        DirectAdministeredObjectInjectionSource directAdministeredObjectInjectionSource = new DirectAdministeredObjectInjectionSource(name, clz, ra);
        directAdministeredObjectInjectionSource.setDescription(this.asString(adminObjectAnnotation, "description"));
        directAdministeredObjectInjectionSource.setInterface(this.asString(adminObjectAnnotation, "interfaceName"));
        directAdministeredObjectInjectionSource.setProperties(this.asArray(adminObjectAnnotation, "properties"));
        BindingConfiguration bindingDescription = new BindingConfiguration(name, (InjectionSource)directAdministeredObjectInjectionSource);
        return bindingDescription;
    }

    private String asString(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asString();
    }

    private String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asStringArray();
    }

    private List<AnnotationInstance> getNestedAdministeredObjectAnnotations(AnnotationInstance adminObjectDefinitions) {
        if (adminObjectDefinitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = adminObjectDefinitions.value().asNestedArray();
        return Arrays.asList(nested);
    }
}

