/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SuppressCache<T> {
    protected final ConcurrentMap<T, Value> map = new ConcurrentHashMap<T, Value>();

    public Value putIfAbsent(T key, long expiry_time) {
        if (key == null) {
            return null;
        }
        Value val = (Value)this.map.get(key);
        if (val == null) {
            val = new Value();
            Value existing = this.map.putIfAbsent(key, val);
            if (existing == null) {
                return val;
            }
            val = existing;
        }
        if (val.update().age() > expiry_time) {
            this.map.remove(key);
            this.map.putIfAbsent(key, new Value());
            return val;
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    public void retainAll(Collection<T> list) {
        if (list != null) {
            this.map.keySet().retainAll(list);
        }
    }

    public void removeAll(Collection<T> list) {
        if (list != null) {
            this.map.keySet().removeAll(list);
        }
    }

    public void removeExpired(long expiry_time) {
        for (Map.Entry entry : this.map.entrySet()) {
            if (((Value)entry.getValue()).age() < expiry_time) continue;
            this.map.remove(entry.getKey());
        }
    }

    public int size() {
        int count = 0;
        for (Value val : this.map.values()) {
            count += val.count();
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static final class Value {
        protected final long timestamp = System.currentTimeMillis();
        protected int count = 1;

        public long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public synchronized Value update() {
            ++this.count;
            return this;
        }

        public int count() {
            return this.count;
        }

        public String toString() {
            return this.count + " update(s) in " + this.age() + " ms";
        }
    }
}

