/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Comparator;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerOperations;
import org.jboss.as.logging.logmanager.PropertySorter;

abstract class AbstractFileHandlerDefinition
extends AbstractHandlerDefinition {
    public static final String CHANGE_FILE_OPERATION_NAME = "change-file";
    static final SimpleOperationDefinition CHANGE_FILE = new SimpleOperationDefinitionBuilder("change-file", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.FILE}).build();
    private final ResolvePathHandler resolvePathHandler;

    protected AbstractFileHandlerDefinition(PathElement path, Class<? extends Handler> type, ResolvePathHandler resolvePathHandler, AttributeDefinition ... attributes) {
        super(path, type, new PropertySorter.DefaultPropertySorter(FileNameLastComparator.INSTANCE), attributes);
        this.resolvePathHandler = resolvePathHandler;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler((OperationDefinition)CHANGE_FILE, HandlerOperations.CHANGE_FILE);
        if (this.resolvePathHandler != null) {
            registration.registerOperationHandler(this.resolvePathHandler.getOperationDefinition(), (OperationStepHandler)this.resolvePathHandler);
        }
    }

    private static class FileNameLastComparator
    implements Comparator<String> {
        static final FileNameLastComparator INSTANCE = new FileNameLastComparator();
        static final int EQUAL = 0;
        static final int GREATER = 1;
        static final int LESS = -1;
        private final String filePropertyName = CommonAttributes.FILE.getPropertyName();

        private FileNameLastComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (this.filePropertyName.equals(o1)) {
                return 1;
            }
            if (this.filePropertyName.equals(o2)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

