/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.validators;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.resolvers.SizeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SizeValidator
extends ModelTypeValidator {
    public SizeValidator() {
        this(false);
    }

    public SizeValidator(boolean nullable) {
        super(ModelType.STRING, nullable);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String stringValue = value.asString();
            try {
                SizeResolver.INSTANCE.parseSize(value);
            }
            catch (IllegalArgumentException e) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSize(stringValue));
            }
            catch (IllegalStateException e) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSize(stringValue));
            }
        }
    }
}

