/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "SECURITY";
    public static final SecurityContextHandleFactory INSTANCE = new SecurityContextHandleFactory();

    private SecurityContextHandleFactory() {
    }

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new SecurityContextHandle();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 300;
    }

    @Override
    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeObject(contextHandle);
    }

    @Override
    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (ContextHandle)in.readObject();
    }

    private static class SecurityContextHandle
    implements ContextHandle {
        private final SecurityContext securityContext = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextHandle.this.saveSecurityContext();
            }
        }) : this.saveSecurityContext();
        private SecurityContext previous;

        private SecurityContextHandle() {
        }

        private SecurityContext saveSecurityContext() {
            return SecurityContextAssociation.getSecurityContext();
        }

        @Override
        public String getFactoryName() {
            return SecurityContextHandleFactory.NAME;
        }

        @Override
        public void setup() throws IllegalStateException {
            this.previous = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return SecurityContextHandle.this.setupSecurityContext();
                }
            }) : this.setupSecurityContext();
        }

        private SecurityContext setupSecurityContext() {
            SecurityContext previous = SecurityContextAssociation.getSecurityContext();
            SecurityContextAssociation.setSecurityContext((SecurityContext)this.securityContext);
            return previous;
        }

        @Override
        public void reset() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityContextHandle.this.resetSecurityContext();
                        return null;
                    }
                });
            } else {
                this.resetSecurityContext();
            }
        }

        private void resetSecurityContext() {
            SecurityContextAssociation.setSecurityContext((SecurityContext)this.previous);
        }
    }
}

