/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.dmr.ModelNode;

public class RoleMappingNotRequiredHandler
implements OperationStepHandler {
    private final String roleName;

    private RoleMappingNotRequiredHandler(String roleName) {
        this.roleName = roleName;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set roleMappings = resource.getChildrenNames("role-mapping");
        if (roleMappings.contains(this.roleName)) {
            throw DomainManagementMessages.MESSAGES.roleMappingRemaining(this.roleName);
        }
        context.stepCompleted();
    }

    static void addOperation(OperationContext context, String roleName) {
        ModelNode operation = Util.createEmptyOperation((String)"role-mapping-check", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT}));
        context.addStep(operation, (OperationStepHandler)new RoleMappingNotRequiredHandler(roleName), OperationContext.Stage.MODEL);
    }
}

