/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jbossweb;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.security.NestableGroup;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;

public class JBossWebPrincipalFactory
extends GenericPrincipalFactory {
    private static Constructor jbossWebPrincipalConstructor = JBossWebPrincipalFactory.findJBossGenericPrincipalConstructor();

    protected GenericPrincipal createPrincipal(Principal userPrincipal, List<String> roles) {
        return null;
    }

    public GenericPrincipal createPrincipal(Realm realm, final Principal identity, final Set<String> roleSet, final KeycloakSecurityContext securityContext) {
        KeycloakAccount account = new KeycloakAccount(){

            public Principal getPrincipal() {
                return identity;
            }

            public Set<String> getRoles() {
                return roleSet;
            }

            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(identity);
        Group[] roleSets = this.getRoleSets(roleSet);
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            if (subjectGroup instanceof NestableGroup) {
                SimpleGroup tmp = new SimpleGroup("Roles");
                subjectGroup.addMember((Principal)tmp);
                subjectGroup = tmp;
            }
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        SimpleGroup callerGroup = new SimpleGroup("CallerPrincipal");
        callerGroup.addMember(identity);
        principals.add((Principal)callerGroup);
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        Principal userPrincipal = this.getPrincipal(subject);
        sc.getUtil().createSubjectInfo(userPrincipal, (Object)account, subject);
        ArrayList<String> rolesAsStringList = new ArrayList<String>();
        rolesAsStringList.addAll(roleSet);
        try {
            return (GenericPrincipal)jbossWebPrincipalConstructor.newInstance(realm, userPrincipal.getName(), null, rolesAsStringList, userPrincipal, null, account, null, subject);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to create JBossGenericPrincipal", t);
        }
    }

    protected Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add((Principal)roles);
        }
        return roles;
    }

    protected Group[] getRoleSets(Collection<String> roleSet) {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (String role : roleSet) {
            roles.addMember((Principal)new SimplePrincipal(role));
        }
        return roleSets;
    }

    static Constructor findJBossGenericPrincipalConstructor() {
        for (Constructor<?> c : JBossGenericPrincipal.class.getConstructors()) {
            if (c.getParameterTypes().length != 9 || !c.getParameterTypes()[0].equals(Realm.class) || !c.getParameterTypes()[1].equals(String.class) || !c.getParameterTypes()[3].equals(List.class) || !c.getParameterTypes()[4].equals(Principal.class) || !c.getParameterTypes()[6].equals(Object.class) || !c.getParameterTypes()[8].equals(Subject.class)) continue;
            return c;
        }
        return null;
    }
}

