/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.config.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.jacorb.notification.servant.SequenceProxyPullConsumerImplMBean;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.SequencePullSupplier;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class SequenceProxyPullConsumerImpl
extends AbstractProxyConsumer
implements SequenceProxyPullConsumerOperations,
SequenceProxyPullConsumerImplMBean,
MessageSupplier,
MessageSupplierDelegate {
    private SequencePullSupplier sequencePullSupplier_;
    private final PullMessagesUtility pollTaskUtility_;
    private final long pollInterval_;
    private final PullMessagesOperation pullMessagesOperation_;

    public SequenceProxyPullConsumerImpl(IAdmin admin, ORB orb, POA poa, Configuration config, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, SupplierAdmin supplierAdmin) {
        super(admin, orb, poa, config, taskProcessor, messageFactory, supplierAdmin, offerManager, subscriptionManager);
        this.pollInterval_ = config.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        this.pollTaskUtility_ = new PullMessagesUtility(taskProcessor, this);
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
    }

    public ProxyType MyType() {
        return ProxyType.PULL_SEQUENCE;
    }

    public void disconnect_sequence_pull_consumer() {
        this.destroy();
    }

    public synchronized void connect_sequence_pull_supplier(SequencePullSupplier sequencePullSupplier) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.sequencePullSupplier_ = sequencePullSupplier;
        this.connectClient(sequencePullSupplier);
        this.pollTaskUtility_.startTask(this.pollInterval_);
    }

    protected void disconnectClient() {
        this.pollTaskUtility_.stopTask();
        this.sequencePullSupplier_.disconnect_sequence_pull_supplier();
        this.sequencePullSupplier_ = null;
    }

    public Servant newServant() {
        return new SequenceProxyPullConsumerPOATie(this);
    }

    public MessageSupplierDelegate.PullResult pullMessages() throws Disconnected {
        BooleanHolder _hasEvent = new BooleanHolder();
        _hasEvent.value = false;
        StructuredEvent[] _events = this.sequencePullSupplier_.try_pull_structured_events(1, _hasEvent);
        return new MessageSupplierDelegate.PullResult(_events, _hasEvent.value);
    }

    public void queueMessages(MessageSupplierDelegate.PullResult pullResult) {
        StructuredEvent[] _events = (StructuredEvent[])pullResult.data_;
        Message[] _messages = this.newMessages(_events);
        for (int x = 0; x < _messages.length; ++x) {
            this.processMessage(_messages[x]);
        }
    }

    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }
}

