/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AttributeParser {
    public static final AttributeParser SIMPLE = new AttributeParser(){};
    public static final AttributeParser LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            ModelNode paramVal = this.parse(attribute, value, reader);
            operation.get(attribute.getName()).add(paramVal);
        }
    };
    public static final AttributeParser STRING_LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            if (value == null) {
                return;
            }
            for (String element : value.split(",")) {
                this.parseAndAddParameterElement(attribute, element, operation, reader);
            }
        }

        private void parseAndAddParameterElement(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            ModelNode paramVal = this.parse(attribute, value, reader);
            operation.get(attribute.getName()).add(paramVal);
        }
    };

    public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(attribute, value, reader);
        operation.get(attribute.getName()).set(paramVal);
    }

    public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.parse(attribute, value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    private ModelNode parse(AttributeDefinition attribute, String value) throws OperationFailedException {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = attribute.isAllowExpression() ? ParseUtils.parsePossibleExpression(trimmed) : new ModelNode().set(trimmed);
            if (node.getType() != ModelType.EXPRESSION) {
                switch (attribute.getType()) {
                    case BIG_DECIMAL: {
                        node.set(node.asBigDecimal());
                        break;
                    }
                    case BIG_INTEGER: {
                        node.set(node.asBigInteger());
                        break;
                    }
                    case BOOLEAN: {
                        node.set(node.asBoolean());
                        break;
                    }
                    case BYTES: {
                        node.set(node.asBytes());
                        break;
                    }
                    case DOUBLE: {
                        node.set(node.asDouble());
                        break;
                    }
                    case INT: {
                        node.set(node.asInt());
                        break;
                    }
                    case LONG: {
                        node.set(node.asLong());
                    }
                }
            }
        } else {
            node = new ModelNode();
        }
        ParameterValidator validator = attribute instanceof ListAttributeDefinition ? ((ListAttributeDefinition)attribute).getElementValidator() : (attribute instanceof MapAttributeDefinition ? ((MapAttributeDefinition)attribute).getElementValidator() : attribute.getValidator());
        validator.validateParameter(attribute.getXmlName(), node);
        return node;
    }

    public static final class DiscardOldDefaultValueParser
    extends AttributeParser {
        private final String value;

        public DiscardOldDefaultValueParser(String value) {
            this.value = value;
        }

        @Override
        public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
            if (!this.value.equals(value)) {
                return super.parse(attribute, value, reader);
            }
            return new ModelNode();
        }
    }
}

