/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class QueueReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final QueueReadAttributeHandler INSTANCE = new QueueReadAttributeHandler(false);
    public static final QueueReadAttributeHandler RUNTIME_INSTANCE = new QueueReadAttributeHandler(true);
    private ParametersValidator validator = new ParametersValidator();
    private final boolean readStorageAttributes;

    private QueueReadAttributeHandler(boolean readStorageAttributes) {
        this.readStorageAttributes = readStorageAttributes;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (HornetQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
            return;
        }
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String queueName = address.getLastElement().getValue();
        if (QueueDefinition.forwardToRuntimeQueue(context, operation, (OperationStepHandler)RUNTIME_INSTANCE)) {
            context.stepCompleted();
            return;
        }
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(address);
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        QueueControl control = (QueueControl)QueueControl.class.cast(hqServer.getManagementService().getResource("core.queue." + queueName));
        if (control == null) {
            throw ControllerMessages.MESSAGES.managementResourceNotFound(address);
        }
        if (CommonAttributes.MESSAGE_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getMessageCount());
        } else if (CommonAttributes.SCHEDULED_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getScheduledCount());
        } else if (CommonAttributes.CONSUMER_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getConsumerCount());
        } else if (CommonAttributes.DELIVERING_COUNT.getName().equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if (CommonAttributes.MESSAGES_ADDED.getName().equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if (QueueDefinition.ID.getName().equals(attributeName)) {
            context.getResult().set(control.getID());
        } else if (CommonAttributes.PAUSED.getName().equals(attributeName)) {
            try {
                context.getResult().set(control.isPaused());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (CommonAttributes.TEMPORARY.getName().equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else if (QueueDefinition.EXPIRY_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getExpiryAddress());
        } else if (QueueDefinition.DEAD_LETTER_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getDeadLetterAddress());
        } else if (this.readStorageAttributes && QueueReadAttributeHandler.getStorageAttributeNames().contains(attributeName)) {
            if (QueueDefinition.ADDRESS.getName().equals(attributeName)) {
                context.getResult().set(control.getAddress());
            } else if (CommonAttributes.DURABLE.getName().equals(attributeName)) {
                context.getResult().set(control.isDurable());
            } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                ModelNode result = context.getResult();
                String filter = control.getFilter();
                if (filter != null) {
                    result.set(filter);
                }
            }
        } else {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
        }
        context.stepCompleted();
    }

    private static List<String> getStorageAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (SimpleAttributeDefinition attr : QueueDefinition.ATTRIBUTES) {
            names.add(attr.getName());
        }
        return names;
    }
}

