/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.ParallelIterableMap;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceCacheLoaderTask;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.persistence.PrimaryOwnerFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceManagerImpl
implements MapReduceManager {
    private static final Log log = LogFactory.getLog(MapReduceManagerImpl.class);
    private ClusteringDependentLogic cdl;
    private EmbeddedCacheManager cacheManager;
    private PersistenceManager persistenceManager;
    private ExecutorService executorService;
    private TimeService timeService;
    private int chunkSize;

    MapReduceManagerImpl() {
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, PersistenceManager persistenceManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, ClusteringDependentLogic cdl, TimeService timeService, Configuration configuration) {
        this.cacheManager = cacheManager;
        this.persistenceManager = persistenceManager;
        this.cdl = cdl;
        this.executorService = asyncTransportExecutor;
        this.timeService = timeService;
        this.chunkSize = configuration.clustering().stateTransfer().chunkSize();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public <KIn, VIn, KOut, VOut> Map<KOut, List<VOut>> mapAndCombineForLocalReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        CollectableCollector<KOut, VOut> collector = this.map(mcc);
        this.combine(mcc, collector);
        return collector.collectedValues();
    }

    @Override
    public <KIn, VIn, KOut, VOut> Set<KOut> mapAndCombineForDistributedReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        try {
            return this.mapAndCombine(mcc);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public <KOut, VOut> Map<KOut, VOut> reduce(ReduceCommand<KOut, VOut> reduceCommand) throws InterruptedException {
        ConcurrentMap result = CollectionFactory.makeConcurrentMap((int)256);
        this.reduce(reduceCommand, result);
        return result;
    }

    @Override
    public <KOut, VOut> void reduce(ReduceCommand<KOut, VOut> reduceCommand, String resultCache) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(resultCache);
        this.reduce(reduceCommand, (Map<KOut, VOut>)((Object)cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KOut, VOut> void reduce(ReduceCommand<KOut, VOut> reduceCommand, final Map<KOut, VOut> result) throws InterruptedException {
        boolean noInputKeys;
        Set<KOut> keys = reduceCommand.getKeys();
        final String taskId = reduceCommand.getTaskId();
        boolean bl = noInputKeys = keys == null || keys.isEmpty();
        if (noInputKeys) {
            throw new IllegalStateException("Reduce phase of MapReduceTask " + taskId + " on node " + this.cdl.getAddress() + " executed with empty input keys");
        }
        final Reducer<KOut, VOut> reducer = reduceCommand.getReducer();
        boolean sharedTmpCacheUsed = reduceCommand.isUseIntermediateSharedCache();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s at %s", taskId, reduceCommand, this.cdl.getAddress());
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            Cache cache = this.cacheManager.getCache(reduceCommand.getCacheName());
            taskLifecycleService.onPreExecute(reducer, cache);
            IntermediateKeyFilter filter = new IntermediateKeyFilter(taskId, !sharedTmpCacheUsed);
            DataContainer dc = cache.getAdvancedCache().getDataContainer();
            dc.executeTask(filter, new DataContainerTask<IntermediateKey<KOut>, List<VOut>>(){

                public void apply(IntermediateKey<KOut> k, InternalCacheEntry<IntermediateKey<KOut>, List<VOut>> v) {
                    Object key = k.getKey();
                    Iterable value = this.getValue(v);
                    if (value == null) {
                        throw new IllegalStateException("Found invalid value in intermediate cache, for key " + key + " during reduce phase execution on " + MapReduceManagerImpl.this.cacheManager.getAddress() + " for M/R task " + taskId);
                    }
                    Object reduced = reducer.reduce(key, value.iterator());
                    result.put(key, reduced);
                    log.tracef("For m/r task %s reduced %s to %s at %s ", new Object[]{taskId, key, reduced, MapReduceManagerImpl.this.cdl.getAddress()});
                }
            });
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Reduce for task %s took %s milliseconds", reduceCommand.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(reducer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> CollectableCollector<KOut, VOut> map(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(mcc.getCacheName());
        Set<KIn> keys = mcc.getKeys();
        int maxCSize = mcc.getMaxCollectorSize();
        final Mapper mapper = mcc.getMapper();
        boolean inputKeysSpecified = keys != null && !keys.isEmpty();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        final SynchronizedCollector collector = new SynchronizedCollector(new DefaultCollector<KIn, VIn, KOut, VOut>(mcc, maxCSize));
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        log.tracef("For m/r task %s invoking %s with input keys %s", mcc.getTaskId(), mcc, keys);
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            taskLifecycleService.onPreExecute(mapper, cache);
            if (inputKeysSpecified) {
                for (KIn key : keys) {
                    Object value = cache.get(key);
                    if (value == null) continue;
                    mapper.map(key, value, collector);
                }
            } else {
                dc.executeTask(new PrimaryOwnerFilter(this.cdl), new DataContainerTask<KIn, VIn>(){

                    public void apply(KIn key, InternalCacheEntry<KIn, VIn> v) {
                        Object value = this.getValue(v);
                        if (value != null) {
                            mapper.map(key, value, collector);
                        }
                    }
                });
            }
            if (this.persistenceManager != null && !inputKeysSpecified) {
                CompositeKeyFilter keyFilter = new CompositeKeyFilter(new PrimaryOwnerFilter(this.cdl), new CollectionKeyFilter(dc.keySet()));
                this.persistenceManager.processOnAllStores(keyFilter, new MapReduceCacheLoaderTask<KIn, VIn, KOut, VOut>(mapper, collector), true, false);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Map phase for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(mapper);
        }
        return collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> Set<KOut> mapAndCombine(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws Exception {
        Cache cache = this.cacheManager.getCache(mcc.getCacheName());
        Set<KIn> keys = mcc.getKeys();
        int maxCSize = mcc.getMaxCollectorSize();
        Mapper<KIn, Object, KOut, VOut> mapper = mcc.getMapper();
        boolean inputKeysSpecified = keys != null && !keys.isEmpty();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        log.tracef("For m/r task %s invoking %s with input keys %s", mcc.getTaskId(), mcc, mcc.getKeys());
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        HashSet<KOut> intermediateKeys = new HashSet<KOut>();
        try {
            taskLifecycleService.onPreExecute(mapper, cache);
            if (inputKeysSpecified) {
                DefaultCollector<KIn, VIn, KOut, VOut> c = new DefaultCollector<KIn, VIn, KOut, VOut>(mcc, maxCSize);
                for (KIn key : keys) {
                    Object value = cache.get(key);
                    if (value == null) continue;
                    mapper.map(key, value, c);
                }
                this.combine(mcc, c);
                Set<KOut> s = this.migrateIntermediateKeysAndValues(mcc, c.collectedValues());
                intermediateKeys.addAll(s);
            } else {
                MapCombineTask<KIn, VIn, KOut, VOut> task = new MapCombineTask<KIn, VIn, KOut, VOut>(mcc, maxCSize);
                dc.executeTask(new PrimaryOwnerFilter(this.cdl), task);
                intermediateKeys.addAll(((MapCombineTask)task).getMigratedIntermediateKeys());
                Map combinedValues = ((MapCombineTask)task).collectedValues();
                Set<KOut> lastOne = this.migrateIntermediateKeysAndValues(mcc, combinedValues);
                intermediateKeys.addAll(lastOne);
            }
            if (this.persistenceManager != null && !inputKeysSpecified) {
                CompositeKeyFilter keyFilter = new CompositeKeyFilter(new PrimaryOwnerFilter(this.cdl), new CollectionKeyFilter(dc.keySet()));
                MapCombineTask<KIn, VIn, KOut, VOut> task = new MapCombineTask<KIn, VIn, KOut, VOut>(mcc, maxCSize);
                this.persistenceManager.processOnAllStores(keyFilter, task, true, false);
                intermediateKeys.addAll(((MapCombineTask)task).getMigratedIntermediateKeys());
                Map combinedValues = ((MapCombineTask)task).collectedValues();
                Set<KOut> lastOne = this.migrateIntermediateKeysAndValues(mcc, combinedValues);
                intermediateKeys.addAll(lastOne);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Map phase for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(mapper);
        }
        return intermediateKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> void combine(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, CollectableCollector<KOut, VOut> c) {
        if (mcc.hasCombiner()) {
            Reducer<KOut, VOut> combiner = mcc.getCombiner();
            Cache cache = this.cacheManager.getCache(mcc.getCacheName());
            log.tracef("For m/r task %s invoking combiner %s at %s", mcc.getTaskId(), mcc, this.cdl.getAddress());
            MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
            long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
            try {
                taskLifecycleService.onPreExecute(combiner, cache);
                for (Map.Entry<KOut, List<VOut>> e : c.collectedValues().entrySet()) {
                    List<VOut> mapped = e.getValue();
                    if (mapped.size() <= 1) continue;
                    VOut reduced = combiner.reduce(e.getKey(), mapped.iterator());
                    c.emitReduced(e.getKey(), reduced);
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.tracef("Combine for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
                }
                taskLifecycleService.onPostExecute(combiner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <KIn, VIn, KOut, VOut> Set<KOut> migrateIntermediateKeysAndValues(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, Map<KOut, List<VOut>> collectedValues) {
        String taskId = mcc.getTaskId();
        String tmpCacheName = mcc.getIntermediateCacheName();
        Cache tmpCache = this.cacheManager.getCache(tmpCacheName);
        if (tmpCache == null) {
            throw new IllegalStateException("Temporary cache for MapReduceTask " + taskId + " named " + tmpCacheName + " not found on " + this.cdl.getAddress());
        }
        HashSet<KOut> mapPhaseKeys = new HashSet<KOut>();
        DistributionManager dm = tmpCache.getAdvancedCache().getDistributionManager();
        Map<Address, List<KOut>> keysToNodes = this.mapKeysToNodes(dm, taskId, collectedValues.keySet());
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        tmpCache = tmpCache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        try {
            for (Map.Entry<Address, List<KOut>> entry : keysToNodes.entrySet()) {
                List<KOut> keysHashedToAddress = entry.getValue();
                try {
                    log.tracef("For m/r task %s migrating intermediate keys %s to %s", taskId, keysHashedToAddress, entry.getKey());
                    for (KOut key : keysHashedToAddress) {
                        List<VOut> values = collectedValues.get(key);
                        int entryTransferCount = this.chunkSize;
                        for (int i = 0; i < values.size(); i += entryTransferCount) {
                            List<VOut> chunk = values.subList(i, Math.min(values.size(), i + entryTransferCount));
                            DeltaList<VOut> delta = new DeltaList<VOut>(chunk);
                            tmpCache.put(new IntermediateKey<KOut>(taskId, key), delta);
                        }
                        mapPhaseKeys.add(key);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Could not move intermediate keys/values for M/R task " + taskId, (Throwable)e);
                    return mapPhaseKeys;
                }
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Migrating keys for task %s took %s milliseconds (Migrated %s keys)", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS), mapPhaseKeys.size());
            }
        }
    }

    @Override
    public <T> Map<Address, List<T>> mapKeysToNodes(DistributionManager dm, String taskId, Collection<T> keysToMap) {
        HashMap<Address, List<T>> addressToKey = new HashMap<Address, List<T>>();
        for (T key : keysToMap) {
            Address ownerOfKey = dm.getPrimaryLocation(new IntermediateKey<T>(taskId, key));
            ArrayList<T> keysAtNode = (ArrayList<T>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new ArrayList<T>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    protected <KIn> Set<KIn> filterLocalPrimaryOwner(Set<KIn> nodeLocalKeys, DistributionManager dm) {
        HashSet<KIn> selectedKeys = new HashSet<KIn>();
        for (KIn key : nodeLocalKeys) {
            Address primaryLocation = dm != null ? dm.getPrimaryLocation(key) : this.cdl.getAddress();
            if (primaryLocation == null || !primaryLocation.equals(this.cdl.getAddress())) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }

    public static final class IntermediateKey<V>
    implements Serializable {
        private static final long serialVersionUID = 4434717760740027918L;
        private final String taskId;
        private final V key;

        public IntermediateKey(String taskId, V key) {
            this.taskId = taskId;
            this.key = key;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public V getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IntermediateKey)) {
                return false;
            }
            IntermediateKey other = (IntermediateKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
        }

        public String toString() {
            return "IntermediateCompositeKey [taskId=" + this.taskId + ", key=" + this.key + "]";
        }
    }

    public static class DeltaAwareListExternalizer
    extends AbstractExternalizer<DeltaAwareList> {
        private static final long serialVersionUID = -8956663669844107351L;

        public void writeObject(ObjectOutput output, DeltaAwareList deltaAwareList) throws IOException {
            output.writeObject(deltaAwareList.list);
        }

        public DeltaAwareList readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new DeltaAwareList((List)input.readObject());
        }

        public Integer getId() {
            return 132;
        }

        public Set<Class<? extends DeltaAwareList>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{DeltaAwareList.class});
        }
    }

    public static class DeltaListExternalizer
    extends AbstractExternalizer<DeltaList> {
        private static final long serialVersionUID = 5859147782602054109L;

        public void writeObject(ObjectOutput output, DeltaList list) throws IOException {
            output.writeObject(list.deltas);
        }

        public DeltaList readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new DeltaList((List)input.readObject());
        }

        public Integer getId() {
            return 131;
        }

        public Set<Class<? extends DeltaList>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{DeltaList.class});
        }
    }

    private static class DeltaList<E>
    implements Delta {
        private final List<E> deltas;

        public DeltaList(List<E> list) {
            this.deltas = new ArrayList<E>(list);
        }

        @Override
        public DeltaAware merge(DeltaAware d) {
            DeltaAwareList<E> other = null;
            if (d instanceof DeltaAwareList) {
                other = (DeltaAwareList<E>)d;
                ((DeltaAwareList)other).list.addAll(this.deltas);
            } else {
                other = new DeltaAwareList<E>(this.deltas);
            }
            return other;
        }
    }

    private static class DeltaAwareList<E>
    implements Iterable<E>,
    DeltaAware {
        private final List<E> list;

        public DeltaAwareList(List<E> list) {
            this.list = list;
        }

        @Override
        public Delta delta() {
            return new DeltaList<E>(this.list);
        }

        @Override
        public void commit() {
            this.list.clear();
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }
    }

    private final class SynchronizedCollector<KOut, VOut>
    implements CollectableCollector<KOut, VOut> {
        private CollectableCollector<KOut, VOut> delegate;

        public SynchronizedCollector(CollectableCollector<KOut, VOut> delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized void emit(KOut key, VOut value) {
            this.delegate.emit(key, value);
        }

        @Override
        public synchronized void emitReduced(KOut key, VOut value) {
            this.delegate.emitReduced(key, value);
        }

        @Override
        public synchronized Map<KOut, List<VOut>> collectedValues() {
            return this.delegate.collectedValues();
        }
    }

    private static interface CollectableCollector<K, V>
    extends Collector<K, V> {
        public Map<K, List<V>> collectedValues();

        public void emitReduced(K var1, V var2);
    }

    private final class DefaultCollector<K, V, KOut, VOut>
    implements CollectableCollector<KOut, VOut> {
        private Map<KOut, List<VOut>> store = new HashMap<KOut, List<VOut>>(1024, 0.75f);
        private final AtomicInteger emitCount = new AtomicInteger();
        private final int maxCollectorSize;
        private MapCombineCommand<K, V, KOut, VOut> mcc;

        public DefaultCollector(MapCombineCommand<K, V, KOut, VOut> mcc, int maxCollectorSize) {
            this.maxCollectorSize = maxCollectorSize;
            this.mcc = mcc;
        }

        @Override
        public void emit(KOut key, VOut value) {
            List<VOut> list = this.store.get(key);
            if (list == null) {
                list = new ArrayList<VOut>(128);
                this.store.put(key, list);
            }
            list.add(value);
            this.emitCount.incrementAndGet();
            if (this.isOverflown() && this.mcc.hasCombiner()) {
                MapReduceManagerImpl.this.combine(this.mcc, this);
            }
        }

        @Override
        public void emitReduced(KOut key, VOut value) {
            List<VOut> list = this.store.get(key);
            int prevSize = list.size();
            list.clear();
            list.add(value);
            this.emitCount.addAndGet(-prevSize + 1);
        }

        @Override
        public Map<KOut, List<VOut>> collectedValues() {
            return this.store;
        }

        public void reset() {
            this.store.clear();
            this.emitCount.set(0);
        }

        public boolean isEmpty() {
            return this.store.isEmpty();
        }

        public void emit(Map<KOut, List<VOut>> combined) {
            for (Map.Entry<KOut, List<VOut>> e : combined.entrySet()) {
                KOut k = e.getKey();
                List<VOut> values = e.getValue();
                for (VOut v : values) {
                    this.emit(k, v);
                }
            }
        }

        public boolean isOverflown() {
            return this.emitCount.get() > this.maxCollectorSize;
        }
    }

    private static final class IntermediateKeyFilter<T>
    implements KeyFilter<IntermediateKey<T>> {
        private final String taskId;
        private final boolean acceptAll;

        public IntermediateKeyFilter(String taskId, boolean acceptAll) {
            if (taskId == null || taskId.isEmpty()) {
                throw new IllegalArgumentException("Invalid task Id " + taskId);
            }
            this.taskId = taskId;
            this.acceptAll = acceptAll;
        }

        @Override
        public boolean accept(IntermediateKey<T> key) {
            if (this.acceptAll) {
                return true;
            }
            if (key != null) {
                return this.taskId.equals(key.getTaskId());
            }
            return false;
        }
    }

    private final class MapCombineTask<K, V, KOut, VOut>
    extends DataContainerTask<K, V>
    implements AdvancedCacheLoader.CacheLoaderTask<K, V> {
        private final MapCombineCommand<K, V, KOut, VOut> mcc;
        private final Set<KOut> intermediateKeys;
        private final int queueLimit;
        private final BlockingQueue<DefaultCollector<K, V, KOut, VOut>> queue;

        public MapCombineTask(MapCombineCommand<K, V, KOut, VOut> mcc, int maxCollectorSize) throws Exception {
            this.queueLimit = Runtime.getRuntime().availableProcessors() * 2;
            this.queue = new ArrayBlockingQueue<DefaultCollector<K, V, KOut, VOut>>(this.queueLimit + 1);
            this.mcc = mcc;
            this.intermediateKeys = Collections.synchronizedSet(new HashSet());
            for (int i = 0; i < this.queueLimit; ++i) {
                this.queue.put(new DefaultCollector<K, V, KOut, VOut>(mcc, maxCollectorSize));
            }
        }

        public void apply(K key, InternalCacheEntry<K, V> v) {
            V value = this.getValue(v);
            if (value != null) {
                try {
                    this.executeMapWithCollector(key, value);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void processEntry(MarshalledEntry<K, V> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            this.executeMapWithCollector(marshalledEntry.getKey(), this.getValue(marshalledEntry));
        }

        @Override
        protected V getValue(InternalCacheEntry<K, V> entry) {
            if (entry != null) {
                Object value = entry.getValue();
                if (value instanceof MarshalledValue) {
                    value = ((MarshalledValue)value).get();
                }
                return value;
            }
            return null;
        }

        private Set<KOut> getMigratedIntermediateKeys() {
            return this.intermediateKeys;
        }

        private Map<KOut, List<VOut>> collectedValues() {
            DefaultCollector finalCollector = new DefaultCollector(this.mcc, Integer.MAX_VALUE);
            for (DefaultCollector defaultCollector : this.queue) {
                if (defaultCollector.isEmpty()) continue;
                finalCollector.emit(defaultCollector.collectedValues());
                defaultCollector.reset();
            }
            MapReduceManagerImpl.this.combine(this.mcc, finalCollector);
            return finalCollector.collectedValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeMapWithCollector(K key, V value) throws InterruptedException {
            DefaultCollector<K, V, KOut, VOut> c = null;
            try {
                c = this.queue.take();
                this.mcc.getMapper().map(key, value, c);
                this.migrate(c);
            }
            finally {
                this.queue.put(c);
            }
        }

        private void migrate(DefaultCollector<K, V, KOut, VOut> c) {
            if (c.isOverflown()) {
                Set migratedKeys = MapReduceManagerImpl.this.migrateIntermediateKeysAndValues(this.mcc, c.collectedValues());
                this.intermediateKeys.addAll(migratedKeys);
                c.reset();
            }
        }

        @Override
        private V getValue(MarshalledEntry<K, V> marshalledEntry) {
            V loadedValue = marshalledEntry.getValue();
            if (loadedValue instanceof MarshalledValue) {
                return (V)((MarshalledValue)loadedValue).get();
            }
            return loadedValue;
        }
    }

    private abstract class DataContainerTask<K, V>
    implements ParallelIterableMap.KeyValueAction<K, InternalCacheEntry<K, V>> {
        private DataContainerTask() {
        }

        protected V getValue(InternalCacheEntry<K, V> entry) {
            if (entry != null && !entry.isExpired(MapReduceManagerImpl.this.timeService.wallClockTime())) {
                Object value = entry.getValue();
                if (value instanceof MarshalledValue) {
                    value = ((MarshalledValue)value).get();
                }
                return value;
            }
            return null;
        }
    }
}

