/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.embedded.ServerStartException;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.embedded.logging.EmbeddedLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.threads.AsyncFuture;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class EmbeddedStandAloneServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";

    private EmbeddedStandAloneServerFactory() {
    }

    public static StandaloneServer create(File jbossHomeDir, final ModuleLoader moduleLoader, final Properties systemProps, final Map<String, String> systemEnv, final String[] cmdargs) {
        if (jbossHomeDir == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHomeDir");
        }
        if (moduleLoader == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("moduleLoader");
        }
        if (systemProps == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemProps");
        }
        if (systemEnv == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemEnv");
        }
        if (cmdargs == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("cmdargs");
        }
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        StandaloneServer standaloneServer = new StandaloneServer(){
            private ServiceContainer serviceContainer;
            private ServerDeploymentManager serverDeploymentManager;
            private Context context;
            private ModelControllerClient modelControllerClient;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deploy(File file) throws IOException, ExecutionException, InterruptedException {
                InputStream is = VFSUtils.createJarFileInputStream((VirtualFile)VFS.getChild((URI)file.toURI()));
                try {
                    this.execute(this.serverDeploymentManager.newDeploymentPlan().add(file.getName(), is).andDeploy().build());
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }

            private ServerDeploymentPlanResult execute(DeploymentPlan deploymentPlan) throws ExecutionException, InterruptedException {
                return (ServerDeploymentPlanResult)this.serverDeploymentManager.execute(deploymentPlan).get();
            }

            @Override
            public Context getContext() {
                if (this.context == null) {
                    throw ServerLogger.ROOT_LOGGER.namingContextHasNotBeenSet();
                }
                return this.context;
            }

            @Override
            public ModelControllerClient getModelControllerClient() {
                return this.modelControllerClient;
            }

            @Override
            public void start() throws ServerStartException {
                try {
                    ServerEnvironment serverEnvironment = Main.determineEnvironment((String[])cmdargs, (Properties)systemProps, (Map)systemEnv, (ServerEnvironment.LaunchType)ServerEnvironment.LaunchType.EMBEDDED);
                    Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                    Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
                    configuration.setModuleLoader(moduleLoader);
                    AsyncFuture future = bootstrap.startup(configuration, Collections.emptyList());
                    this.serviceContainer = (ServiceContainer)future.get();
                    ServiceController controllerService = this.serviceContainer.getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
                    ModelController controller = (ModelController)controllerService.getValue();
                    this.serverDeploymentManager = new ModelControllerServerDeploymentManager(controller);
                    this.modelControllerClient = controller.createClient((Executor)Executors.newCachedThreadPool());
                    this.context = new InitialContext();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw EmbeddedLogger.ROOT_LOGGER.cannotStartEmbeddedServer(ex);
                }
            }

            @Override
            public void stop() {
                if (this.context != null) {
                    try {
                        this.context.close();
                        this.context = null;
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                }
                this.serverDeploymentManager = null;
                if (this.serviceContainer != null) {
                    try {
                        this.serviceContainer.shutdown();
                        this.serviceContainer.awaitTermination();
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void undeploy(File file) throws ExecutionException, InterruptedException {
                this.execute(this.serverDeploymentManager.newDeploymentPlan().undeploy(file.getName()).andRemoveUndeployed().build());
            }

            @Override
            public ServiceController<?> getService(ServiceName serviceName) {
                return this.serviceContainer != null ? this.serviceContainer.getService(serviceName) : null;
            }
        };
        return standaloneServer;
    }

    static void setupCleanDirectories(Properties props) {
        File jbossHomeDir = new File(props.getProperty("jboss.home.dir"));
        EmbeddedStandAloneServerFactory.setupCleanDirectories(jbossHomeDir, props);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedStandAloneServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.config.dir", "configuration", true);
        File originalDataDir = EmbeddedStandAloneServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.data.dir", "data", false);
        File configDir = new File(tempRoot, "config");
        configDir.mkdir();
        File dataDir = new File(tempRoot, "data");
        dataDir.mkdir();
        File deploymentsDir = new File(tempRoot, "deployments");
        deploymentsDir.mkdir();
        EmbeddedStandAloneServerFactory.copyDirectory(originalConfigDir, configDir);
        if (originalDataDir.exists()) {
            EmbeddedStandAloneServerFactory.copyDirectory(originalDataDir, dataDir);
        }
        props.put("jboss.server.base.dir", tempRoot.getAbsolutePath());
        props.put("jboss.server.config.dir", configDir.getAbsolutePath());
        props.put("jboss.server.data.dir", dataDir.getAbsolutePath());
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.server.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone" + File.separator + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw ServerLogger.ROOT_LOGGER.embeddedServerDirectoryNotFound("standalone" + File.separator + relativeLocation, jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.server.config.dir", dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        File root = new File(tempRoot);
        if (!root.exists()) {
            root.mkdirs();
        }
        EmbeddedStandAloneServerFactory.validateDirectory("jboss.test.clean.root", root);
        root = new File(root, "configs");
        root.mkdir();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        root = new File(root, format.format(new Date()));
        root.mkdir();
        return root;
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileDoesNotExist(property, file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileIsNotADirectory(property, file.getAbsolutePath());
        }
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                EmbeddedStandAloneServerFactory.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
            }
        }
    }
}

