/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobParser;
import org.jberet.spi.JobXmlResolver;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.batch._private.BatchLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

class JobXmlResolverService
implements Service<JobXmlResolver>,
JobXmlResolver {
    private final Set<JobXmlResolver> jobXmlResolvers;
    private final Map<String, String> cachedJobInfo;
    private final Map<String, VirtualFile> jobXmlFiles;
    private final ClassLoader classLoader;

    public JobXmlResolverService() {
        this.classLoader = null;
        this.cachedJobInfo = Collections.emptyMap();
        this.jobXmlResolvers = Collections.emptySet();
        this.jobXmlFiles = Collections.emptyMap();
    }

    public JobXmlResolverService(ClassLoader classLoader, Collection<VirtualFile> jobXmlFiles) {
        this.classLoader = classLoader;
        this.cachedJobInfo = new LinkedHashMap<String, String>();
        this.jobXmlResolvers = new LinkedHashSet<JobXmlResolver>();
        this.jobXmlFiles = new LinkedHashMap<String, VirtualFile>(jobXmlFiles.size());
        for (VirtualFile jobXmlFile : jobXmlFiles) {
            this.jobXmlFiles.put(jobXmlFile.getName(), jobXmlFile);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.classLoader != null) {
            for (JobXmlResolver jobXmlResolver : ServiceLoader.load(JobXmlResolver.class, this.classLoader)) {
                this.jobXmlResolvers.add(jobXmlResolver);
                for (String jobXml : jobXmlResolver.getJobXmlNames(this.classLoader)) {
                    this.cachedJobInfo.put(jobXml, jobXmlResolver.resolveJobName(jobXml, this.classLoader));
                }
            }
            for (Map.Entry entry : this.jobXmlFiles.entrySet()) {
                try {
                    Job job = JobParser.parseJob((InputStream)((VirtualFile)entry.getValue()).openStream(), (ClassLoader)this.classLoader, (XMLResolver)new XMLResolver(){

                        @Override
                        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                            try {
                                return JobXmlResolverService.this.jobXmlFiles.containsKey(systemID) ? ((VirtualFile)JobXmlResolverService.this.jobXmlFiles.get(systemID)).openStream() : null;
                            }
                            catch (IOException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    });
                    this.cachedJobInfo.put((String)entry.getKey(), job.getId());
                }
                catch (IOException | XMLStreamException e) {
                    BatchLogger.LOGGER.invalidJobXmlFile((String)entry.getKey());
                }
            }
        }
    }

    public synchronized void stop(StopContext context) {
        this.jobXmlResolvers.clear();
        this.jobXmlFiles.clear();
        this.cachedJobInfo.clear();
    }

    public JobXmlResolver getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        VirtualFile file;
        JobXmlResolverService jobXmlResolverService = this;
        synchronized (jobXmlResolverService) {
            if (this.jobXmlFiles.isEmpty() && this.jobXmlResolvers.isEmpty()) {
                return null;
            }
            for (JobXmlResolver resolver : this.jobXmlResolvers) {
                InputStream in = resolver.resolveJobXml(jobXml, classLoader);
                if (in == null) continue;
                return in;
            }
        }
        JobXmlResolverService jobXmlResolverService2 = this;
        synchronized (jobXmlResolverService2) {
            file = this.jobXmlFiles.get(jobXml);
        }
        if (file == null) {
            return null;
        }
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        return file.openStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return file.openStream();
    }

    public synchronized Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return this.cachedJobInfo.keySet();
    }

    public synchronized String resolveJobName(String jobXml, ClassLoader classLoader) {
        return this.cachedJobInfo.get(jobXml);
    }
}

