/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import java.util.Map;
import org.xnio.Options;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.XnioChannelOption;
import org.xnio.netty.transport.XnioServerSocketChannelConfig;

final class XnioServerSocketChannelConfigImpl
extends DefaultChannelConfig
implements XnioServerSocketChannelConfig {
    private final AbstractXnioServerSocketChannel channel;

    XnioServerSocketChannelConfigImpl(AbstractXnioServerSocketChannel channel) {
        super((Channel)channel);
        this.channel = channel;
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{XnioChannelOption.BALANCING_CONNECTIONS, XnioChannelOption.BALANCING_TOKENS, XnioChannelOption.CONNECTION_HIGH_WATER, XnioChannelOption.CONNECTION_LOW_WATER});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == XnioChannelOption.BALANCING_CONNECTIONS) {
            return (T)Integer.valueOf(this.getBalancingConnections());
        }
        if (option == XnioChannelOption.BALANCING_TOKENS) {
            return (T)Integer.valueOf(this.getBalancingTokens());
        }
        if (option == XnioChannelOption.CONNECTION_HIGH_WATER) {
            return (T)Integer.valueOf(this.getConnectionHighWater());
        }
        if (option == XnioChannelOption.CONNECTION_LOW_WATER) {
            return (T)Integer.valueOf(this.getConnectionLowWater());
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == XnioChannelOption.BALANCING_CONNECTIONS) {
            this.setBalancingConnections((Integer)value);
        } else if (option == XnioChannelOption.BALANCING_TOKENS) {
            this.setBalancingTokens((Integer)value);
        } else if (option == XnioChannelOption.CONNECTION_HIGH_WATER) {
            this.setConnectionHighWater((Integer)value);
        } else if (option == XnioChannelOption.CONNECTION_LOW_WATER) {
            this.setConnectionLowWater((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    public int getBacklog() {
        return (Integer)this.channel.getOption(Options.BACKLOG);
    }

    @Override
    public XnioServerSocketChannelConfig setBacklog(int backlog) {
        this.channel.setOption(Options.BACKLOG, backlog);
        return this;
    }

    public boolean isReuseAddress() {
        return (Boolean)this.channel.getOption(Options.REUSE_ADDRESSES);
    }

    @Override
    public XnioServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        this.channel.setOption(Options.REUSE_ADDRESSES, reuseAddress);
        return this;
    }

    public int getReceiveBufferSize() {
        return (Integer)this.channel.getOption(Options.RECEIVE_BUFFER);
    }

    @Override
    public XnioServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        this.channel.setOption(Options.RECEIVE_BUFFER, receiveBufferSize);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XnioServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setConnectionHighWater(int connectionHighWater) {
        this.channel.setOption(Options.CONNECTION_HIGH_WATER, connectionHighWater);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setConnectionLowWater(int connectionLowWater) {
        this.channel.setOption(Options.CONNECTION_LOW_WATER, connectionLowWater);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setBalancingTokens(int balancingTokens) {
        this.channel.setOption(Options.BALANCING_TOKENS, balancingTokens);
        return this;
    }

    @Override
    public XnioServerSocketChannelConfig setBalancingConnections(int connections) {
        this.channel.setOption(Options.BALANCING_CONNECTIONS, connections);
        return this;
    }

    @Override
    public int getConnectionHighWater() {
        return (Integer)this.channel.getOption(Options.CONNECTION_HIGH_WATER);
    }

    @Override
    public int getConnectionLowWater() {
        return (Integer)this.channel.getOption(Options.CONNECTION_LOW_WATER);
    }

    @Override
    public int getBalancingTokens() {
        return (Integer)this.channel.getOption(Options.BALANCING_TOKENS);
    }

    @Override
    public int getBalancingConnections() {
        return (Integer)this.channel.getOption(Options.BALANCING_CONNECTIONS);
    }
}

