/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.ClientConnection;
import org.keycloak.Version;
import org.keycloak.freemarker.BrowserSecurityHeaderSetup;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.FreeMarkerUtil;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.AdminRoot;

public class AdminConsole {
    protected static final Logger logger = Logger.getLogger(AdminConsole.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakApplication keycloak;
    protected AppAuthManager authManager;
    protected RealmModel realm;

    public AdminConsole(RealmModel realm) {
        this.realm = realm;
        this.authManager = new AppAuthManager();
    }

    @Path(value="config")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ClientManager.InstallationAdapterConfig config() {
        ClientModel consoleApp = this.realm.getClientByClientId("security-admin-console");
        if (consoleApp == null) {
            throw new NotFoundException("Could not find admin console client");
        }
        return new ClientManager().toInstallationRepresentation(this.realm, consoleApp, this.keycloak.getBaseUri(this.uriInfo));
    }

    @Path(value="whoami")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response whoAmI(@Context HttpHeaders headers) {
        String displayName;
        RealmManager realmManager = new RealmManager(this.session);
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateBearerToken(this.session, this.realm, this.uriInfo, this.clientConnection, headers);
        if (authResult == null) {
            return Response.status((int)401).build();
        }
        UserModel user = authResult.getUser();
        if (user.getFirstName() != null && !user.getFirstName().trim().equals("") || user.getLastName() != null && !user.getLastName().trim().equals("")) {
            displayName = user.getFirstName();
            if (user.getLastName() != null) {
                displayName = displayName != null ? displayName + " " + user.getLastName() : user.getLastName();
            }
        } else {
            displayName = user.getUsername();
        }
        RealmModel masterRealm = this.getAdminstrationRealm(realmManager);
        HashMap<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();
        if (masterRealm == null) {
            throw new NotFoundException("No realm found");
        }
        boolean createRealm = false;
        if (this.realm.equals(masterRealm)) {
            logger.debug((Object)"setting up realm access for a master realm user");
            createRealm = user.hasRole(masterRealm.getRole(AdminRoles.CREATE_REALM));
            this.addMasterRealmAccess(this.realm, user, realmAccess);
        } else {
            logger.debug((Object)"setting up realm access for a realm user");
            this.addRealmAccess(this.realm, user, realmAccess);
        }
        return Response.ok((Object)new WhoAmI(user.getId(), this.realm.getName(), displayName, createRealm, realmAccess)).build();
    }

    private void addRealmAccess(RealmModel realm, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        RealmManager realmManager = new RealmManager(this.session);
        ClientModel realmAdminApp = realm.getClientByClientId(realmManager.getRealmAdminClientId(realm));
        Set roles = realmAdminApp.getRoles();
        for (RoleModel role : roles) {
            if (!user.hasRole(role)) continue;
            if (!realmAdminAccess.containsKey(realm.getName())) {
                realmAdminAccess.put(realm.getName(), new HashSet());
            }
            realmAdminAccess.get(realm.getName()).add(role.getName());
        }
    }

    private void addMasterRealmAccess(RealmModel masterRealm, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        List realms = this.session.realms().getRealms();
        for (RealmModel realm : realms) {
            ClientModel realmAdminApp = realm.getMasterAdminClient();
            Set roles = realmAdminApp.getRoles();
            for (RoleModel role : roles) {
                if (!user.hasRole(role)) continue;
                if (!realmAdminAccess.containsKey(realm.getName())) {
                    realmAdminAccess.put(realm.getName(), new HashSet());
                }
                realmAdminAccess.get(realm.getName()).add(role.getName());
            }
        }
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout() {
        URI redirect = AdminRoot.adminConsoleUrl(this.uriInfo).build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(OIDCLoginProtocolService.logoutUrl(this.uriInfo).queryParam("redirect_uri", new Object[]{redirect.toString()}).build(new Object[]{this.realm.getName()})).build();
    }

    protected RealmModel getAdminstrationRealm(RealmManager realmManager) {
        return realmManager.getKeycloakAdminstrationRealm();
    }

    @GET
    @NoCache
    public Response getMainPage() throws URISyntaxException, IOException, FreeMarkerException {
        if (!this.uriInfo.getRequestUri().getPath().endsWith("/")) {
            return Response.status((int)302).location(this.uriInfo.getRequestUriBuilder().path("/").build(new Object[0])).build();
        }
        String adminTheme = this.realm.getAdminTheme();
        if (adminTheme == null) {
            adminTheme = "keycloak";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        URI baseUri = this.uriInfo.getBaseUri();
        String authUrl = baseUri.toString();
        authUrl = authUrl.substring(0, authUrl.length() - 1);
        map.put("authUrl", authUrl);
        map.put("resourceUrl", Urls.themeRoot(baseUri) + "/admin/" + adminTheme);
        map.put("resourceVersion", Version.RESOURCES_VERSION);
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        Theme theme = themeProvider.getTheme(this.realm.getAdminTheme(), Theme.Type.ADMIN);
        map.put("properties", theme.getProperties());
        FreeMarkerUtil freeMarkerUtil = new FreeMarkerUtil();
        String result = freeMarkerUtil.processTemplate(map, "index.ftl", theme);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).type("text/html").entity((Object)result);
        BrowserSecurityHeaderSetup.headers((Response.ResponseBuilder)builder, (RealmModel)this.realm);
        return builder.build();
    }

    @GET
    @Path(value="{indexhtml: index.html}")
    public Response getIndexHtmlRedirect() {
        return Response.status((int)302).location(this.uriInfo.getRequestUriBuilder().path("../").build(new Object[0])).build();
    }

    public static class WhoAmI {
        protected String userId;
        protected String realm;
        protected String displayName;
        @JsonProperty(value="createRealm")
        protected boolean createRealm;
        @JsonProperty(value="realm_access")
        protected Map<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();

        public WhoAmI() {
        }

        public WhoAmI(String userId, String realm, String displayName, boolean createRealm, Map<String, Set<String>> realmAccess) {
            this.userId = userId;
            this.realm = realm;
            this.displayName = displayName;
            this.createRealm = createRealm;
            this.realmAccess = realmAccess;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isCreateRealm() {
            return this.createRealm;
        }

        public void setCreateRealm(boolean createRealm) {
            this.createRealm = createRealm;
        }

        public Map<String, Set<String>> getRealmAccess() {
            return this.realmAccess;
        }

        public void setRealmAccess(Map<String, Set<String>> realmAccess) {
            this.realmAccess = realmAccess;
        }
    }
}

