/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.DistributedWorkManagerStatistics;
import org.jboss.jca.core.api.workmanager.DistributedWorkManagerStatisticsValues;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.notification.NotificationListener;
import org.jboss.jca.core.spi.workmanager.transport.Transport;
import org.jboss.logging.Logger;

public class DistributedWorkManagerStatisticsImpl
implements DistributedWorkManagerStatistics,
NotificationListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)DistributedWorkManagerStatistics.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private Address own;
    private Transport transport;
    private Set<Address> workManagers;
    private AtomicInteger successful;
    private AtomicInteger failed;
    private AtomicInteger doWorkAccepted;
    private AtomicInteger doWorkRejected;
    private AtomicInteger scheduleWorkAccepted;
    private AtomicInteger scheduleWorkRejected;
    private AtomicInteger startWorkAccepted;
    private AtomicInteger startWorkRejected;
    private boolean initialized;

    public DistributedWorkManagerStatisticsImpl() {
        this(null, null);
    }

    public DistributedWorkManagerStatisticsImpl(Address ownId, Transport t) {
        this.own = ownId;
        this.transport = t;
        this.workManagers = Collections.synchronizedSet(new HashSet());
        this.successful = new AtomicInteger(0);
        this.failed = new AtomicInteger(0);
        this.doWorkAccepted = new AtomicInteger(0);
        this.doWorkRejected = new AtomicInteger(0);
        this.scheduleWorkAccepted = new AtomicInteger(0);
        this.scheduleWorkRejected = new AtomicInteger(0);
        this.startWorkAccepted = new AtomicInteger(0);
        this.startWorkRejected = new AtomicInteger(0);
        this.initialized = false;
    }

    public void setOwnId(Address v) {
        this.own = v;
    }

    public void setTransport(Transport v) {
        this.transport = v;
    }

    public void initialize(DistributedWorkManagerStatisticsValues values) {
        this.successful.set(values.getWorkSuccessful());
        this.failed.set(values.getWorkFailed());
        this.doWorkAccepted.set(values.getDoWorkAccepted());
        this.doWorkRejected.set(values.getDoWorkRejected());
        this.scheduleWorkAccepted.set(values.getScheduleWorkAccepted());
        this.scheduleWorkRejected.set(values.getScheduleWorkRejected());
        this.startWorkAccepted.set(values.getStartWorkAccepted());
        this.startWorkRejected.set(values.getStartWorkRejected());
        this.initialized = true;
    }

    public void join(Address address) {
        DistributedWorkManagerStatisticsValues values;
        if (trace) {
            log.tracef("join(%s)", address);
        }
        this.workManagers.add(address);
        if (!this.initialized && this.own != null && this.transport != null && !this.own.equals((Object)address) && this.transport.isInitialized() && (values = this.transport.getDistributedStatistics(address)) != null) {
            this.initialize(values);
        }
    }

    public void leave(Address address) {
        if (trace) {
            log.tracef("leave(%s)", address);
        }
        this.workManagers.remove(address);
    }

    public void updateShortRunningFree(Address address, long free) {
    }

    public void updateLongRunningFree(Address address, long free) {
    }

    public int getWorkActive() {
        return -1;
    }

    public int getWorkSuccessful() {
        return this.successful.get();
    }

    public void deltaWorkSuccessful() {
        this.successful.incrementAndGet();
    }

    public int getWorkFailed() {
        return this.failed.get();
    }

    public void deltaWorkFailed() {
        this.failed.incrementAndGet();
    }

    public int getDoWorkAccepted() {
        return this.doWorkAccepted.get();
    }

    public void deltaDoWorkAccepted() {
        this.doWorkAccepted.incrementAndGet();
    }

    public int getDoWorkRejected() {
        return this.doWorkRejected.get();
    }

    public void deltaDoWorkRejected() {
        this.doWorkRejected.incrementAndGet();
    }

    public int getScheduleWorkAccepted() {
        return this.scheduleWorkAccepted.get();
    }

    public void deltaScheduleWorkAccepted() {
        this.scheduleWorkAccepted.incrementAndGet();
    }

    public int getScheduleWorkRejected() {
        return this.scheduleWorkRejected.get();
    }

    public void deltaScheduleWorkRejected() {
        this.scheduleWorkRejected.incrementAndGet();
    }

    public int getStartWorkAccepted() {
        return this.startWorkAccepted.get();
    }

    public void deltaStartWorkAccepted() {
        this.startWorkAccepted.incrementAndGet();
    }

    public int getStartWorkRejected() {
        return this.startWorkRejected.get();
    }

    public void deltaStartWorkRejected() {
        this.startWorkRejected.incrementAndGet();
    }

    public synchronized void clear() {
        this.successful.set(0);
        this.failed.set(0);
        this.doWorkAccepted.set(0);
        this.doWorkRejected.set(0);
        this.scheduleWorkAccepted.set(0);
        this.scheduleWorkRejected.set(0);
        this.startWorkAccepted.set(0);
        this.startWorkRejected.set(0);
        if (trace) {
            log.tracef("clear: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            this.transport.clearDistributedStatistics(this.own);
        }
    }

    void sendDeltaDoWorkAccepted() {
        this.doWorkAccepted.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaDoWorkAccepted: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaDoWorkAccepted(address);
            }
        }
    }

    void sendDeltaDoWorkRejected() {
        this.doWorkRejected.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaDoWorkRejected: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaDoWorkRejected(address);
            }
        }
    }

    void sendDeltaScheduleWorkAccepted() {
        this.scheduleWorkAccepted.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaScheduleWorkAccepted: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaScheduleWorkAccepted(address);
            }
        }
    }

    void sendDeltaScheduleWorkRejected() {
        this.scheduleWorkRejected.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaScheduleWorkRejected: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaScheduleWorkRejected(address);
            }
        }
    }

    void sendDeltaStartWorkAccepted() {
        this.startWorkAccepted.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaStartWorkAccepted: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaStartWorkAccepted(address);
            }
        }
    }

    void sendDeltaStartWorkRejected() {
        this.startWorkRejected.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaStartWorkRejected: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaStartWorkRejected(address);
            }
        }
    }

    void sendDeltaWorkSuccessful() {
        this.successful.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaWorkSuccessful: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaWorkSuccessful(address);
            }
        }
    }

    void sendDeltaWorkFailed() {
        this.failed.incrementAndGet();
        if (trace) {
            log.tracef("sendDeltaWorkFailed: %s", this.workManagers);
        }
        if (this.own != null && this.transport != null && this.transport.isInitialized()) {
            for (Address address : this.workManagers) {
                if (this.own.equals((Object)address)) continue;
                this.transport.deltaWorkFailed(address);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistributedWorkManagerStatisticsImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[transport=").append(this.transport);
        sb.append(" successful=").append(this.getWorkSuccessful());
        sb.append(" failed=").append(this.getWorkFailed());
        sb.append(" doWorkAccepted=").append(this.getDoWorkAccepted());
        sb.append(" doWorkRejected=").append(this.getDoWorkRejected());
        sb.append(" scheduleWorkAccepted=").append(this.getScheduleWorkAccepted());
        sb.append(" scheduleWorkRejected=").append(this.getScheduleWorkRejected());
        sb.append(" startWorkAccepted=").append(this.getStartWorkAccepted());
        sb.append(" startWorkRejected=").append(this.getStartWorkRejected());
        sb.append("]");
        return sb.toString();
    }
}

