/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.ee.BatchContext;

public class InfinispanBatchContext
implements BatchContext {
    private final TransactionManager tm;
    private final Transaction existingTx;
    private final Transaction tx;

    InfinispanBatchContext(TransactionManager tm, Transaction tx) throws SystemException, InvalidTransactionException {
        this.tm = tm;
        this.tx = tx;
        this.existingTx = this.tm.suspend();
        this.tm.resume(this.tx);
    }

    public void close() {
        if (this.existingTx != null && !this.existingTx.equals(this.tx)) {
            try {
                this.tm.resume(this.existingTx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new CacheException(e);
            }
        }
    }
}

