/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import com.google.common.base.Defaults;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractBean<T, S> {
    private final AbstractClassBean<X> declaringBean;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;

    public AbstractProducerBean(BeanAttributes<T> attributes, BeanIdentifier identifier, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, identifier, beanManager);
        this.declaringBean = declaringBean;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    protected void initType() {
        try {
            this.type = this.getEnhancedAnnotated().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw BeanLogger.LOG.producerCastError(this.getEnhancedAnnotated().getJavaClass(), type == null ? " unknown " : type, e);
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.internalInitialize(environment);
        this.initPassivationCapable();
    }

    private void initPassivationCapable() {
        boolean bl = this.passivationCapableBean = !Reflections.isFinal(this.getEnhancedAnnotated().getJavaClass()) || Reflections.isSerializable(this.getEnhancedAnnotated().getJavaClass());
        this.passivationCapableDependency = this.isNormalScoped() ? true : this.getScope().equals(Dependent.class) && this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected T checkReturnValue(T instance) {
        Class injectionPointRawType;
        InjectionPoint injectionPoint;
        if (instance == null && !this.isDependent()) {
            throw BeanLogger.LOG.nullNotAllowedFromProducer(this.getProducer());
        }
        if (instance == null && (injectionPoint = (InjectionPoint)((CurrentInjectionPoint)this.beanManager.getServices().get(CurrentInjectionPoint.class)).peek()) != null && (injectionPointRawType = Reflections.getRawType(injectionPoint.getType())).isPrimitive()) {
            return Reflections.cast(Defaults.defaultValue(injectionPointRawType));
        }
        if (instance != null && !(instance instanceof Serializable)) {
            boolean passivating = this.beanManager.isPassivatingScope(this.getScope());
            if (passivating) {
                throw BeanLogger.LOG.nonSerializableProductError(this.getProducer());
            }
            InjectionPoint injectionPoint2 = (InjectionPoint)((CurrentInjectionPoint)this.beanManager.getServices().get(CurrentInjectionPoint.class)).peek();
            if (injectionPoint2 != null && injectionPoint2.getBean() != null && Beans.isPassivatingScope(injectionPoint2.getBean(), this.beanManager) && injectionPoint2.getMember() instanceof Field && !injectionPoint2.isTransient()) {
                throw BeanLogger.LOG.nonSerializableFieldInjectionError(this, injectionPoint2);
            }
        }
        return instance;
    }

    @Override
    protected void checkType() {
        if (this.beanManager.isPassivatingScope(this.getScope()) && !this.isPassivationCapableBean()) {
            throw BeanLogger.LOG.passivatingBeanNeedsSerializableImpl(this);
        }
    }

    protected boolean isTypeSerializable(Object instance) {
        return instance instanceof Serializable;
    }

    public T create(CreationalContext<T> creationalContext) {
        Object instance = this.getProducer().produce(creationalContext);
        instance = this.checkReturnValue(instance);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        super.destroy(instance, creationalContext);
        try {
            this.getProducer().dispose(instance);
        }
        catch (Exception e) {
            BeanLogger.LOG.errorDestroying(instance, this);
            BeanLogger.LOG.catchingDebug(e);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    public AbstractClassBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    public abstract AnnotatedMember<? super X> getAnnotated();

    public abstract EnhancedAnnotatedMember<T, ?, S> getEnhancedAnnotated();
}

