/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.HashSet;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class ForeignKeySnapshotGenerator
extends JdbcSnapshotGenerator {
    public ForeignKeySnapshotGenerator() {
        super(ForeignKey.class, new Class[]{Table.class});
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(ForeignKey.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            HashSet<String> seenFks = new HashSet<String>();
            try {
                List<CachedRow> importedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getForeignKeys(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), database.correctObjectName(table.getName(), Table.class), null);
                for (CachedRow row : importedKeyMetadataResultSet) {
                    ForeignKey fk = new ForeignKey().setName(row.getString("FK_NAME")).setForeignKeyTable(table);
                    if (!seenFks.add(fk.getName())) continue;
                    table.getOutgoingForeignKeys().add(fk);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        try {
            Table fkTable = ((ForeignKey)example).getForeignKeyTable();
            String searchCatalog = ((AbstractJdbcDatabase)database).getJdbcCatalogName(fkTable.getSchema());
            String searchSchema = ((AbstractJdbcDatabase)database).getJdbcSchemaName(fkTable.getSchema());
            String searchTableName = database.correctObjectName(fkTable.getName(), Table.class);
            List<CachedRow> importedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getForeignKeys(searchCatalog, searchSchema, searchTableName, example.getName());
            ForeignKey foreignKey = null;
            for (CachedRow row : importedKeyMetadataResultSet) {
                String fk_name = this.cleanNameFromDatabase(row.getString("FK_NAME"), database);
                if (snapshot.getDatabase().isCaseSensitive() && (!fk_name.equals(example.getName()) || !fk_name.equalsIgnoreCase(example.getName()))) continue;
                if (foreignKey == null) {
                    foreignKey = new ForeignKey();
                }
                foreignKey.setName(fk_name);
                String fkTableCatalog = this.cleanNameFromDatabase(row.getString("FKTABLE_CAT"), database);
                String fkTableSchema = this.cleanNameFromDatabase(row.getString("FKTABLE_SCHEM"), database);
                String fkTableName = this.cleanNameFromDatabase(row.getString("FKTABLE_NAME"), database);
                Table foreignKeyTable = new Table().setName(fkTableName);
                foreignKeyTable.setSchema(new Schema(new Catalog(fkTableCatalog), fkTableSchema));
                foreignKey.setForeignKeyTable(foreignKeyTable);
                foreignKey.addForeignKeyColumn(new Column(this.cleanNameFromDatabase(row.getString("FKCOLUMN_NAME"), database)).setRelation(foreignKeyTable));
                CatalogAndSchema pkTableSchema = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(row.getString("PKTABLE_CAT"), row.getString("PKTABLE_SCHEM"));
                Table tempPkTable = (Table)new Table().setName(row.getString("PKTABLE_NAME")).setSchema(new Schema(pkTableSchema.getCatalogName(), pkTableSchema.getSchemaName()));
                foreignKey.setPrimaryKeyTable(tempPkTable);
                foreignKey.addPrimaryKeyColumn(new Column(this.cleanNameFromDatabase(row.getString("PKCOLUMN_NAME"), database)).setRelation(tempPkTable));
                ForeignKeyConstraintType updateRule = this.convertToForeignKeyConstraintType(row.getInt("UPDATE_RULE"), database);
                foreignKey.setUpdateRule(updateRule);
                ForeignKeyConstraintType deleteRule = this.convertToForeignKeyConstraintType(row.getInt("DELETE_RULE"), database);
                foreignKey.setDeleteRule(deleteRule);
                short deferrability = row.getShort("DEFERRABILITY");
                if (deferrability == 0 || deferrability == 7) {
                    foreignKey.setDeferrable(false);
                    foreignKey.setInitiallyDeferred(false);
                } else if (deferrability == 5) {
                    foreignKey.setDeferrable(true);
                    foreignKey.setInitiallyDeferred(true);
                } else if (deferrability == 6) {
                    foreignKey.setDeferrable(true);
                    foreignKey.setInitiallyDeferred(false);
                } else {
                    throw new RuntimeException("Unknown deferrability result: " + deferrability);
                }
                if (!database.createsIndexesForForeignKeys()) continue;
                Index exampleIndex = new Index().setTable(foreignKey.getForeignKeyTable());
                exampleIndex.getColumns().addAll(foreignKey.getForeignKeyColumns());
                foreignKey.setBackingIndex(exampleIndex);
            }
            return foreignKey;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected ForeignKeyConstraintType convertToForeignKeyConstraintType(Integer jdbcType, Database database) throws DatabaseException {
        if (jdbcType == null) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (database instanceof MSSQLDatabase) {
            if (jdbcType == 0) {
                return ForeignKeyConstraintType.importedKeyCascade;
            }
            if (jdbcType == 1) {
                return ForeignKeyConstraintType.importedKeyNoAction;
            }
            if (jdbcType == 2) {
                return ForeignKeyConstraintType.importedKeySetNull;
            }
            throw new DatabaseException("Unknown constraint type: " + jdbcType);
        }
        if (jdbcType == 0) {
            return ForeignKeyConstraintType.importedKeyCascade;
        }
        if (jdbcType == 3) {
            return ForeignKeyConstraintType.importedKeyNoAction;
        }
        if (jdbcType == 1) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (jdbcType == 4) {
            return ForeignKeyConstraintType.importedKeySetDefault;
        }
        if (jdbcType == 2) {
            return ForeignKeyConstraintType.importedKeySetNull;
        }
        throw new DatabaseException("Unknown constraint type: " + jdbcType);
    }
}

