CREATE TABLE JOB_INSTANCE (
  JOBINSTANCEID   BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1) CONSTRAINT JOB_INSTANCE_PK PRIMARY KEY,
  VERSION         INTEGER,
  JOBNAME         VARCHAR(512),
  APPLICATIONNAME VARCHAR(512)
)!!

CREATE TABLE JOB_EXECUTION (
  JOBEXECUTIONID  BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1) CONSTRAINT JOB_EXECUTION_PK PRIMARY KEY,
  JOBINSTANCEID   BIGINT             NOT NULL,
  VERSION         INTEGER,
  CREATETIME      TIMESTAMP,
  STARTTIME       TIMESTAMP,
  ENDTIME         TIMESTAMP,
  LASTUPDATEDTIME TIMESTAMP,
  BATCHSTATUS     VARCHAR(30),
  EXITSTATUS      VARCHAR(512),
  JOBPARAMETERS   VARCHAR(3000),
  RESTARTPOSITION VARCHAR(255),
  CONSTRAINT FK_JOB_EXECUTION_JOB_INSTANCE FOREIGN KEY (JOBINSTANCEID) REFERENCES JOB_INSTANCE (JOBINSTANCEID) ON DELETE CASCADE
)!!

CREATE TABLE STEP_EXECUTION (
  STEPEXECUTIONID    BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1) CONSTRAINT STEP_EXECUTION_PK PRIMARY KEY,
  JOBEXECUTIONID     BIGINT             NOT NULL,
  VERSION            INTEGER,
  STEPNAME           VARCHAR(255),
  STARTTIME          TIMESTAMP,
  ENDTIME            TIMESTAMP,
  BATCHSTATUS        VARCHAR(30),
  EXITSTATUS         VARCHAR(512),
  EXECUTIONEXCEPTION VARCHAR(2048),
  PERSISTENTUSERDATA BLOB,
  READCOUNT          INTEGER,
  WRITECOUNT         INTEGER,
  COMMITCOUNT        INTEGER,
  ROLLBACKCOUNT      INTEGER,
  READSKIPCOUNT      INTEGER,
  PROCESSSKIPCOUNT   INTEGER,
  FILTERCOUNT        INTEGER,
  WRITESKIPCOUNT     INTEGER,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  CONSTRAINT FK_STEP_EXECUTION_JOB_EXECUTION FOREIGN KEY (JOBEXECUTIONID) REFERENCES JOB_EXECUTION (JOBEXECUTIONID) ON DELETE CASCADE
)!!

CREATE TABLE PARTITION_EXECUTION (
  PARTITIONEXECUTIONID  INTEGER NOT NULL,
  STEPEXECUTIONID       BIGINT  NOT NULL,
  VERSION               INTEGER,
  BATCHSTATUS           VARCHAR(30),
  EXITSTATUS            VARCHAR(512),
  EXECUTIONEXCEPTION    VARCHAR(2048),
  PERSISTENTUSERDATA    BLOB,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  PRIMARY KEY (PARTITIONEXECUTIONID, STEPEXECUTIONID),
  CONSTRAINT FK_PARTITION_EXECUTION_STEP_EXECUTION FOREIGN KEY (STEPEXECUTIONID) REFERENCES STEP_EXECUTION (STEPEXECUTIONID) ON DELETE CASCADE
)!!

