/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.events.Event;

public class LogBean {
    private List<EventBean> events = new LinkedList<EventBean>();

    public LogBean(List<Event> events) {
        for (Event e : events) {
            this.events.add(new EventBean(e));
        }
    }

    public List<EventBean> getEvents() {
        return this.events;
    }

    public static class DetailBean {
        private Map.Entry<String, String> entry;

        public DetailBean(Map.Entry<String, String> entry) {
            this.entry = entry;
        }

        public String getKey() {
            return this.entry.getKey();
        }

        public String getValue() {
            return this.entry.getValue().replace("_", " ");
        }
    }

    public static class EventBean {
        private Event event;

        public EventBean(Event event) {
            this.event = event;
        }

        public Date getDate() {
            return new Date(this.event.getTime());
        }

        public String getEvent() {
            return this.event.getType().toString().toLowerCase().replace("_", " ");
        }

        public String getClient() {
            return this.event.getClientId();
        }

        public String getIpAddress() {
            return this.event.getIpAddress();
        }

        public List<DetailBean> getDetails() {
            LinkedList<DetailBean> details = new LinkedList<DetailBean>();
            if (this.event.getDetails() != null) {
                for (Map.Entry<String, String> entry : this.event.getDetails().entrySet()) {
                    details.add(new DetailBean(entry));
                }
            }
            return details;
        }
    }
}

