/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.compat;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.compat.ClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.compat.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.compat.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.compat.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UsernameLoginFailureEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UsernameLoginFailureKey;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;

public class MemUserSessionProvider
implements UserSessionProvider {
    private final KeycloakSession session;
    private final ConcurrentHashMap<String, UserSessionEntity> userSessions;
    private final ConcurrentHashMap<String, String> userSessionsByBrokerSessionId;
    private final ConcurrentHashMap<String, Set<String>> userSessionsByBrokerUserId;
    private final ConcurrentHashMap<String, ClientSessionEntity> clientSessions;
    private final ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures;
    private final ConcurrentHashMap<String, UserSessionEntity> offlineUserSessions;
    private final ConcurrentHashMap<String, ClientSessionEntity> offlineClientSessions;

    public MemUserSessionProvider(KeycloakSession session, ConcurrentHashMap<String, UserSessionEntity> userSessions, ConcurrentHashMap<String, String> userSessionsByBrokerSessionId, ConcurrentHashMap<String, Set<String>> userSessionsByBrokerUserId, ConcurrentHashMap<String, ClientSessionEntity> clientSessions, ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures, ConcurrentHashMap<String, UserSessionEntity> offlineUserSessions, ConcurrentHashMap<String, ClientSessionEntity> offlineClientSessions) {
        this.session = session;
        this.userSessions = userSessions;
        this.clientSessions = clientSessions;
        this.loginFailures = loginFailures;
        this.userSessionsByBrokerSessionId = userSessionsByBrokerSessionId;
        this.userSessionsByBrokerUserId = userSessionsByBrokerUserId;
        this.offlineUserSessions = offlineUserSessions;
        this.offlineClientSessions = offlineClientSessions;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientId(client.getId());
        entity.setRealmId(realm.getId());
        this.clientSessions.put(entity.getId(), entity);
        return new ClientSessionAdapter(this.session, this, realm, entity);
    }

    public void removeClientSession(RealmModel realm, ClientSessionModel clientSession) {
        ClientSessionEntity entity = ((ClientSessionAdapter)clientSession).getEntity();
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            UserSessionEntity userSessionEntity = ((UserSessionAdapter)userSession).getEntity();
            userSessionEntity.getClientSessions().remove(entity);
        }
        this.clientSessions.remove(clientSession.getId());
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        ClientSessionEntity entity = this.clientSessions.get(id);
        return entity != null ? new ClientSessionAdapter(this.session, this, realm, entity) : null;
    }

    public ClientSessionModel getClientSession(String id) {
        ClientSessionEntity entity = this.clientSessions.get(id);
        if (entity != null) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
            return new ClientSessionAdapter(this.session, this, realm, entity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        UserSessionEntity entity;
        block6: {
            HashSet<String> set;
            String id = KeycloakModelUtils.generateId();
            entity = new UserSessionEntity();
            entity.setId(id);
            entity.setRealm(realm.getId());
            entity.setUser(user.getId());
            entity.setLoginUsername(loginUsername);
            entity.setIpAddress(ipAddress);
            entity.setAuthMethod(authMethod);
            entity.setRememberMe(rememberMe);
            int currentTime = Time.currentTime();
            entity.setStarted(currentTime);
            entity.setLastSessionRefresh(currentTime);
            entity.setBrokerSessionId(brokerSessionId);
            entity.setBrokerUserId(brokerUserId);
            this.userSessions.put(id, entity);
            if (brokerSessionId != null) {
                this.userSessionsByBrokerSessionId.put(brokerSessionId, id);
            }
            if (brokerUserId == null) break block6;
            do {
                HashSet<String> value;
                if ((set = this.userSessionsByBrokerUserId.get(brokerUserId)) == null && (set = (HashSet<String>)this.userSessionsByBrokerUserId.putIfAbsent(brokerUserId, value = new HashSet<String>())) == null) {
                    set = value;
                }
                HashSet<String> hashSet = set;
                synchronized (hashSet) {
                    set.add(id);
                }
            } while (this.userSessionsByBrokerUserId.get(brokerUserId) != set);
        }
        return new UserSessionAdapter(this.session, this, realm, entity);
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        Set<String> sessions = this.userSessionsByBrokerUserId.get(brokerUserId);
        if (sessions == null) {
            return Collections.emptyList();
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (String id : sessions) {
            UserSessionModel userSession = this.getUserSession(realm, id);
            if (userSession == null) continue;
            userSessions.add(userSession);
        }
        return userSessions;
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        String id = this.userSessionsByBrokerSessionId.get(brokerSessionId);
        if (id == null) {
            return null;
        }
        return this.getUserSession(realm, id);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, id);
        return entity != null ? new UserSessionAdapter(this.session, this, realm, entity) : null;
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, String id) {
        UserSessionEntity entity = this.userSessions.get(id);
        if (entity != null && entity.getRealm().equals(realm.getId())) {
            return entity;
        }
        return null;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity s : this.userSessions.values()) {
            if (!s.getRealm().equals(realm.getId()) || !s.getUser().equals(user.getId())) continue;
            userSessions.add(new UserSessionAdapter(this.session, this, realm, s));
        }
        return userSessions;
    }

    public List<UserSessionModel> getUserSessionsByNote(RealmModel realm, String noteName, String noteValue) {
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity s : this.userSessions.values()) {
            if (!s.getRealm().equals(realm.getId()) || !noteValue.equals(s.getNotes().get(noteName))) continue;
            userSessions.add(new UserSessionAdapter(this.session, this, realm, s));
        }
        return userSessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, false);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, boolean offline) {
        ConcurrentHashMap<String, ClientSessionEntity> clientSessions = offline ? this.offlineClientSessions : this.clientSessions;
        LinkedList<UserSessionEntity> userSessionEntities = new LinkedList<UserSessionEntity>();
        for (ClientSessionEntity s : clientSessions.values()) {
            String realmId = realm.getId();
            String clientId = client.getId();
            if (s.getSession() == null || !s.getSession().getRealm().equals(realmId) || !s.getClientId().equals(clientId) || userSessionEntities.contains(s.getSession())) continue;
            userSessionEntities.add(s.getSession());
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : userSessionEntities) {
            userSessions.add(new UserSessionAdapter(this.session, this, realm, e));
        }
        Collections.sort(userSessions, new UserSessionSort());
        return userSessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults, boolean offline) {
        List<UserSessionModel> userSessions = this.getUserSessions(realm, client, offline);
        if (firstResult > userSessions.size()) {
            return Collections.emptyList();
        }
        int toIndex = firstResult + maxResults < userSessions.size() ? firstResult + maxResults : userSessions.size();
        return userSessions.subList(firstResult, toIndex);
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, false).size();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session.getId());
        if (entity != null) {
            this.userSessions.remove(entity.getId());
            this.remove(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Iterator<UserSessionEntity> itr;
        Iterator<UserSessionEntity> iterator = itr = offline ? this.offlineUserSessions.values().iterator() : this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s = itr.next();
            if (!s.getRealm().equals(realm.getId()) || !s.getUser().equals(user.getId())) continue;
            itr.remove();
            this.remove(s, offline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(UserSessionEntity s, boolean offline) {
        if (offline) {
            for (ClientSessionEntity clientSessionEntity : s.getClientSessions()) {
                this.offlineClientSessions.remove(clientSessionEntity.getId());
            }
        } else {
            Set<String> set;
            if (s.getBrokerSessionId() != null) {
                this.userSessionsByBrokerSessionId.remove(s.getBrokerSessionId());
            }
            if (s.getBrokerUserId() != null && (set = this.userSessionsByBrokerUserId.get(s.getBrokerUserId())) != null) {
                Set<String> set2 = set;
                synchronized (set2) {
                    set.remove(s.getId());
                    if (set.isEmpty()) {
                        this.userSessionsByBrokerUserId.remove(s.getBrokerUserId());
                    }
                }
            }
            for (ClientSessionEntity clientSessionEntity : s.getClientSessions()) {
                this.clientSessions.remove(clientSessionEntity.getId());
            }
        }
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        Object s;
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        Iterator<UserSessionEntity> itr = this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s2 = itr.next();
            if (!s2.getRealm().equals(realm.getId()) || s2.getLastSessionRefresh() >= Time.currentTime() - realm.getSsoSessionIdleTimeout() && s2.getStarted() >= Time.currentTime() - realm.getSsoSessionMaxLifespan()) continue;
            itr.remove();
            this.remove(s2, false);
        }
        int expired = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Iterator<ClientSessionEntity> citr = this.clientSessions.values().iterator();
        while (citr.hasNext()) {
            ClientSessionEntity c = citr.next();
            if (c.getSession() != null || !c.getRealmId().equals(realm.getId()) || c.getTimestamp() >= expired) continue;
            citr.remove();
        }
        itr = this.offlineUserSessions.values().iterator();
        while (itr.hasNext()) {
            s = itr.next();
            if (!((UserSessionEntity)s).getRealm().equals(realm.getId()) || ((UserSessionEntity)s).getLastSessionRefresh() >= Time.currentTime() - realm.getOfflineSessionIdleTimeout()) continue;
            itr.remove();
            this.remove((UserSessionEntity)s, true);
            persister.removeUserSession(((UserSessionEntity)s).getId(), true);
        }
        citr = this.offlineClientSessions.values().iterator();
        while (citr.hasNext()) {
            s = citr.next();
            if (!((ClientSessionEntity)s).getRealmId().equals(realm.getId()) || ((ClientSessionEntity)s).getTimestamp() >= Time.currentTime() - realm.getOfflineSessionIdleTimeout()) continue;
            citr.remove();
            persister.removeClientSession(((ClientSessionEntity)s).getId(), true);
        }
    }

    public void removeUserSessions(RealmModel realm) {
        this.removeUserSessions(realm, false);
    }

    protected void removeUserSessions(RealmModel realm, boolean offline) {
        Iterator<ClientSessionEntity> citr;
        Iterator<UserSessionEntity> itr;
        Iterator<UserSessionEntity> iterator = itr = offline ? this.offlineUserSessions.values().iterator() : this.userSessions.values().iterator();
        while (itr.hasNext()) {
            UserSessionEntity s = itr.next();
            if (!s.getRealm().equals(realm.getId())) continue;
            itr.remove();
            this.remove(s, offline);
        }
        Iterator<ClientSessionEntity> iterator2 = citr = offline ? this.offlineClientSessions.values().iterator() : this.clientSessions.values().iterator();
        while (citr.hasNext()) {
            ClientSessionEntity c = citr.next();
            if (c.getSession() != null || !c.getRealmId().equals(realm.getId())) continue;
            citr.remove();
        }
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureEntity entity = this.loginFailures.get(new UsernameLoginFailureKey(realm.getId(), username));
        return entity != null ? new UsernameLoginFailureAdapter(entity) : null;
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureEntity entity;
        UsernameLoginFailureKey key = new UsernameLoginFailureKey(realm.getId(), username);
        if (this.loginFailures.putIfAbsent(key, entity = new UsernameLoginFailureEntity(username, realm.getId())) != null) {
            throw new ModelDuplicateException();
        }
        return new UsernameLoginFailureAdapter(entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String username) {
        this.loginFailures.remove(new UsernameLoginFailureKey(realm.getId(), username));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        Iterator<UsernameLoginFailureEntity> itr = this.loginFailures.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getRealm().equals(realm.getId())) continue;
            itr.remove();
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm, true);
        this.removeUserSessions(realm, false);
        this.removeAllUserLoginFailures(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(realm, client, true);
        this.onClientRemoved(realm, client, false);
    }

    private void onClientRemoved(RealmModel realm, ClientModel client, boolean offline) {
        ConcurrentHashMap<String, ClientSessionEntity> clientSessionsMap = offline ? this.offlineClientSessions : this.clientSessions;
        for (ClientSessionEntity e : clientSessionsMap.values()) {
            if (!e.getRealmId().equals(realm.getId()) || !e.getClientId().equals(client.getId())) continue;
            clientSessionsMap.remove(e.getId());
            e.getSession().removeClientSession(e);
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.loginFailures.remove(new UsernameLoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailures.remove(new UsernameLoginFailureKey(realm.getId(), user.getEmail()));
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter importedUserSession = this.importUserSession(userSession, true);
        int currentTime = Time.currentTime();
        importedUserSession.getEntity().setStarted(currentTime);
        importedUserSession.setLastSessionRefresh(currentTime);
        return importedUserSession;
    }

    public UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealm(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setLoginUsername(userSession.getLoginUsername());
        if (userSession.getNotes() != null) {
            entity.getNotes().putAll(userSession.getNotes());
        }
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        entity.setUser(userSession.getUser().getId());
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        ConcurrentHashMap<String, UserSessionEntity> sessionsMap = offline ? this.offlineUserSessions : this.userSessions;
        sessionsMap.put(userSession.getId(), entity);
        return new UserSessionAdapter(this.session, this, userSession.getRealm(), entity);
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        UserSessionEntity entity = this.offlineUserSessions.get(userSessionId);
        if (entity != null && entity.getRealm().equals(realm.getId())) {
            return new UserSessionAdapter(this.session, this, realm, entity);
        }
        return null;
    }

    public void removeOfflineUserSession(RealmModel realm, String userSessionId) {
        UserSessionEntity entity = this.offlineUserSessions.get(userSessionId);
        if (entity != null && entity.getRealm().equals(realm.getId())) {
            this.offlineUserSessions.remove(entity);
            this.remove(entity, true);
        }
    }

    public ClientSessionModel createOfflineClientSession(ClientSessionModel clientSession) {
        ClientSessionAdapter offlineClientSession = this.importClientSession(clientSession, true);
        offlineClientSession.setTimestamp(Time.currentTime());
        return offlineClientSession;
    }

    public ClientSessionAdapter importClientSession(ClientSessionModel clientSession, boolean offline) {
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(clientSession.getId());
        entity.setRealmId(clientSession.getRealm().getId());
        entity.setAction(clientSession.getAction());
        entity.setAuthenticatorStatus(clientSession.getExecutionStatus());
        entity.setAuthMethod(clientSession.getAuthMethod());
        if (clientSession.getAuthenticatedUser() != null) {
            entity.setAuthUserId(clientSession.getAuthenticatedUser().getId());
        }
        entity.setClientId(clientSession.getClient().getId());
        if (clientSession.getNotes() != null) {
            entity.getNotes().putAll(clientSession.getNotes());
        }
        entity.setProtocolMappers(clientSession.getProtocolMappers());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setRoles(clientSession.getRoles());
        entity.setTimestamp(clientSession.getTimestamp());
        if (clientSession.getUserSessionNotes() != null) {
            entity.getUserSessionNotes().putAll(clientSession.getUserSessionNotes());
        }
        ConcurrentHashMap<String, ClientSessionEntity> clientSessionsMap = offline ? this.offlineClientSessions : this.clientSessions;
        clientSessionsMap.put(clientSession.getId(), entity);
        return new ClientSessionAdapter(this.session, this, clientSession.getRealm(), entity);
    }

    public ClientSessionModel getOfflineClientSession(RealmModel realm, String clientSessionId) {
        ClientSessionEntity entity = this.offlineClientSessions.get(clientSessionId);
        if (entity != null && entity.getRealmId().equals(realm.getId())) {
            return new ClientSessionAdapter(this.session, this, realm, entity);
        }
        return null;
    }

    public List<ClientSessionModel> getOfflineClientSessions(RealmModel realm, UserModel user) {
        LinkedList<ClientSessionModel> clientSessions = new LinkedList<ClientSessionModel>();
        for (UserSessionEntity s : this.offlineUserSessions.values()) {
            if (!s.getRealm().equals(realm.getId()) || !s.getUser().equals(user.getId())) continue;
            for (ClientSessionEntity cls : s.getClientSessions()) {
                ClientSessionAdapter clAdapter = new ClientSessionAdapter(this.session, this, realm, cls);
                clientSessions.add(clAdapter);
            }
        }
        return clientSessions;
    }

    public void removeOfflineClientSession(RealmModel realm, String clientSessionId) {
        ClientSessionEntity entity = this.offlineClientSessions.get(clientSessionId);
        if (entity != null && entity.getRealmId().equals(realm.getId())) {
            this.offlineClientSessions.remove(entity.getId());
            UserSessionEntity userSession = entity.getSession();
            userSession.removeClientSession(entity);
        }
    }

    public int getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, true).size();
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    public void close() {
    }

    private class UserSessionSort
    implements Comparator<UserSessionModel> {
        private UserSessionSort() {
        }

        @Override
        public int compare(UserSessionModel o1, UserSessionModel o2) {
            int r = o1.getStarted() - o2.getStarted();
            if (r == 0) {
                return o1.getId().compareTo(o2.getId());
            }
            return r;
        }
    }
}

